package applet;

import java.math.*;
/**
 *
 * @author  Frank
 */
public class boundary2d {
    
    private double Pw1;
    
    private double Pw2;
    
    private double wo; //initial weight
    
    private double[] X1 = new double[2]; 
    private double[] X2 = new double[2];
    
    
    private double[] w = new double[2]; //weights for each dimension
    
    private double[] q = new double[2];
    
    private double[] p = new double[2];
    
    /** Creates a new instance of boundary */
    public boundary2d(double Prior_w1, double Prior_w2, double[] qq, double[] pp){ //, int Xstart, int Xend) {
   
        Pw1=Prior_w1;
        Pw2=Prior_w2;
        q=qq;
        p=pp;    
        
        fix_vars();
    }
    
    public void calculate(){
       
       int Xstart =0;
       int Xend = 1;
       cal_weights();
       cal_boundary_coords(); 
        
    }
    
    public double[] getX1(){
        return X1;
    }
      
    public double[] getX2(){
        return X2;
    }
    
    
    public double[] getw(){
        return w;
    }
    
    public double getwo(){
        return wo;
    }
  
  
    
    private void cal_boundary_coords(){
   //This calculates the boundary..
   // by setting G(x)=0, we know know that x1=(-w2x2-wo)/w1
        
          
        if ((w[0] != 0) && (Double.isNaN(w[0]) == false)) {
            
            double dX1[]={0,0};
            double dX2[]={0,1};
             
            for (int i =0; i<2; i++){
                dX1[i]= -(w[1]*dX2[i] + wo)/w[0];
            }
            
            X1=dX1;
            X2=dX2;
        }
        else if ((w[1] != 0) && (Double.isNaN(w[1]) == false)){ 
            //this is for X2 since w[1] is actually w2..

            double dX1[]={0,1};
            double dX2[]={0,0};
             
            for (int i =0; i<2; i++){
                dX2[i]= -(w[0]*dX1[i] + wo)/w[1];
            }
            
            X1=dX1;
            X2=dX2;
        }
        
 
    System.out.println(X1[0] + " " +X1[1]);
    System.out.println(X2[0] + " " +X2[1]);
    }
       
    //this routine calculates the weights
    private void cal_weights(){
    
        // assign temporaries
        double dblwo=0;
        double dblwi[]={0,0};
        
        //calculate the weights here - only 2 dimensions              
        for (int i =0; i<2; i++){
        dblwo+=Math.log((1-p[i])/(1-q[i])) + Math.log(Pw1/Pw2);                           
        dblwi[i]=Math.log((p[i]*(1-q[i]))/(q[i]*(1-p[i])));
        }
   
        wo=dblwo;
        w=dblwi;
    }
    
    
    private void fix_vars(){
     // This will fix the values of variables so that we will not have to deal with
     // NANs or +- infinity... just assign assymptotic-like numbers:
        
        for (int i=0; i<2; i++){
        
            if (p[i] == 0)
                p[i] = 0.001;
            
            if (q[i] == 0)
                q[i] = 0.001;
            
            if (p[i] == 1)
                p[i] = 0.999;
            
            if (q[i] == 1)
                q[i] = 0.999;      
        }
        
        if (Pw1 == 0)
            Pw1 = 0.001;
        if (Pw1 == 1)
            Pw1 = 0.999;           
        if (Pw2 == 0)
            Pw2 = 0.001;            
        if (Pw2 == 1)
            Pw2 = 0.999;
        
    }
    
}
