/*
 * Decompiled with CFR 0.152.
 */
package chapman.math;

import java.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class Statistics
implements Cloneable {
    private double[] data;

    public Statistics() {
    }

    public Statistics(double[] x) {
        this.data = x;
    }

    public double mean() {
        return Statistics.mean((double[])this.data);
    }

    public double median() {
        return Statistics.median((double[])this.data);
    }

    public double stdDev() {
        return Statistics.stdDev((double[])this.data);
    }

    public double skewness() {
        return Statistics.skewness((double[])this.data);
    }

    public double kurtosis() {
        return Statistics.kurtosis((double[])this.data);
    }

    public static double mean(double[] data) {
        if (data.length < 1) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += data[i];
            ++i;
        }
        return sum / (double)data.length;
    }

    public static double median(double[] data) {
        double median = 0.0;
        if (data.length < 1) {
            return 0.0;
        }
        double[] out = new double[data.length];
        int i = 0;
        while (i < data.length) {
            out[i] = data[i];
            ++i;
        }
        Arrays.sort(out);
        median = out.length % 2 == 0 ? (out[out.length / 2 - 1] + out[out.length / 2]) / 2.0 : out[out.length / 2];
        return median;
    }

    public static double stdDev(double[] data) {
        return Math.sqrt(Statistics.var((double[])data));
    }

    public static double skewness(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double m3 = Statistics.moment((double[])data, (int)3);
        double sm2 = Math.sqrt(Statistics.moment((double[])data, (int)2));
        return m3 / Math.pow(sm2, 3.0);
    }

    public static double kurtosis(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double m4 = Statistics.moment((double[])data, (int)4);
        double sm2 = Math.sqrt(Statistics.moment((double[])data, (int)2));
        return m4 / Math.pow(sm2, 4.0);
    }

    public static double var(double[] data) {
        if (data.length < 2) {
            return 0.0;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        double var = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += data[i];
            sum2 += data[i] * data[i];
            ++i;
        }
        var = ((double)data.length * sum2 - sum * sum) / (double)(data.length * (data.length - 1));
        return var;
    }

    public static double[] cumProbability(double[] data, double[] x) {
        Arrays.sort(data);
        double max = data[data.length - 1];
        double min = data[0];
        double[] cumProb = new double[x.length];
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < data.length) {
                if (data[j] <= x[i]) {
                    int n = i;
                    cumProb[n] = cumProb[n] + 1.0;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < x.length) {
            cumProb[i2] = cumProb[i2] / (double)data.length;
            ++i2;
        }
        return cumProb;
    }

    public static double[] percentile(double[] data, double[] p) {
        double[] percLoc = new double[p.length];
        Arrays.sort(data);
        double max = data[data.length - 1];
        double min = data[0];
        double dx = (max - min) / 99.0;
        double[] xval = new double[100];
        int i = 0;
        while (i < xval.length) {
            xval[i] = min + (double)i * dx;
            ++i;
        }
        double[] cumProb = new double[xval.length];
        int i2 = 0;
        while (i2 < xval.length) {
            int j = 0;
            while (j < data.length) {
                if (data[j] <= xval[i2]) {
                    int n = i2;
                    cumProb[n] = cumProb[n] + 1.0;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < xval.length) {
            cumProb[i3] = cumProb[i3] / (double)data.length;
            ++i3;
        }
        int i4 = 0;
        while (i4 < p.length) {
            percLoc[i4] = Statistics.interp2((double[])cumProb, (double[])xval, (double)p[i4]);
            ++i4;
        }
        return percLoc;
    }

    public static double maxVal(double[] data) {
        double maxVal = data[0];
        int i = 0;
        while (i < data.length) {
            if (data[i] > maxVal) {
                maxVal = data[i];
            }
            ++i;
        }
        return maxVal;
    }

    public static double minVal(double[] data) {
        double minVal = data[0];
        int i = 0;
        while (i < data.length) {
            if (data[i] < minVal) {
                minVal = data[i];
            }
            ++i;
        }
        return minVal;
    }

    private static double moment(double[] x, int order) {
        if (order == 1) {
            return 0.0;
        }
        double mu = Statistics.mean((double[])x);
        double sum = 0.0;
        int i = 0;
        while (i < x.length) {
            sum += Math.pow(x[i] - mu, order);
            ++i;
        }
        return sum / (double)x.length;
    }

    private static double interp1(double[] x, double[] y, double x0) {
        double y0;
        if (x0 < x[0]) {
            y0 = y[0];
        } else if (x0 >= x[x.length - 1]) {
            y0 = y[x.length - 1];
        } else {
            int i = 0;
            i = 0;
            while (i < x.length - 1) {
                if (x0 >= x[i] && x0 <= x[i + 1]) break;
                ++i;
            }
            if (i < x.length) {
                double dx = (x0 - x[i]) / (x[i + 1] - x[i]);
                y0 = y[i] + (y[i + 1] - y[i]) * dx;
            } else {
                y0 = y[x.length - 1];
            }
        }
        return y0;
    }

    private static double interp2(double[] x, double[] y, double x0) {
        double y0;
        if (x0 < x[0]) {
            y0 = Double.NaN;
        } else if (x0 > x[x.length - 1]) {
            y0 = Double.NaN;
        } else {
            int i = 0;
            i = 0;
            while (i < x.length - 1) {
                if (x0 >= x[i] && x0 <= x[i + 1]) break;
                ++i;
            }
            if (i < x.length) {
                double dx = (x0 - x[i]) / (x[i + 1] - x[i]);
                y0 = y[i] + (y[i + 1] - y[i]) * dx;
            } else {
                y0 = y[x.length - 1];
            }
        }
        return y0;
    }
}

