/*
 * Decompiled with CFR 0.152.
 */
package chapman.math;

import chapman.math.Complex;
import chapman.math.InvalidArraySizeException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SigProc {
    private static final double TWO_PI = Math.PI * 2;
    public static final int NO_NORM = 0;
    public static final int NORM = 1;

    public static double[] calcFreq(double fs, int fftSize) {
        double df = fs / (double)fftSize;
        double[] fArray = new double[fftSize];
        fArray[0] = 0.0;
        fArray[fftSize / 2] = fs / 2.0;
        int i = 1;
        while (i < fftSize / 2) {
            fArray[i] = (double)i * df;
            fArray[fftSize - i] = (double)(-i) * df;
            ++i;
        }
        return fArray;
    }

    public static Complex[] correl(Complex[] za, Complex[] zb) {
        return SigProc.correlCore((Complex[])za, (Complex[])zb, (int)0);
    }

    public static double[] correl(double[] xa, double[] xb) {
        return SigProc.correlCore((double[])xa, (double[])xb, (int)0);
    }

    public static Complex[] correl(Complex[] za, Complex[] zb, int norm) {
        return SigProc.correlCore((Complex[])za, (Complex[])zb, (int)norm);
    }

    public static double[] correl(double[] xa, double[] xb, int norm) {
        return SigProc.correlCore((double[])xa, (double[])xb, (int)norm);
    }

    public static Complex[] conv(Complex[] za, Complex[] zb) {
        return SigProc.convCore((Complex[])za, (Complex[])zb);
    }

    public static Complex[] fft(Complex[] z) {
        int exp = 0;
        int m = 2;
        int n = z.length;
        do {
            ++exp;
        } while ((m = 2 * m) < z.length);
        if (m != z.length) {
            String s = "Invalid FFT array size: " + z.length;
            throw new InvalidArraySizeException(s);
        }
        double[] x = new double[n];
        double[] y = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = z[i].re();
            y[i] = z[i].im();
            ++i;
        }
        SigProc.fftCore((double[])x, (double[])y, (boolean)false);
        Complex[] z1 = new Complex[z.length];
        i = 0;
        while (i < n) {
            z1[i] = new Complex(x[i], y[i]);
            ++i;
        }
        return z1;
    }

    public static Complex[] fft(Complex[] z, int size) {
        int exp = 0;
        int m = 2;
        int n = size;
        do {
            ++exp;
        } while ((m = 2 * m) < size);
        if (m != size) {
            String s = "Invalid FFT array size: " + size;
            throw new InvalidArraySizeException(s);
        }
        double[] x = new double[n];
        double[] y = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = z[i].re();
            y[i] = z[i].im();
            ++i;
        }
        SigProc.fftCore((double[])x, (double[])y, (boolean)false);
        Complex[] z1 = new Complex[size];
        i = 0;
        while (i < n) {
            z1[i] = new Complex(x[i], y[i]);
            ++i;
        }
        return z1;
    }

    public static Complex[] fftswap(Complex[] z) {
        Complex[] z1 = new Complex[z.length];
        int mid = z.length / 2;
        int k = 0;
        int i = mid + 1;
        while (i < z.length) {
            z1[k++] = z[i];
            ++i;
        }
        i = 0;
        while (i < mid + 1) {
            z1[k++] = z[i];
            ++i;
        }
        return z1;
    }

    public static double[] fftswap(double[] d) {
        double[] d1 = new double[d.length];
        int mid = d.length / 2;
        int k = 0;
        int i = mid + 1;
        while (i < d.length) {
            d1[k++] = d[i];
            ++i;
        }
        i = 0;
        while (i < mid + 1) {
            d1[k++] = d[i];
            ++i;
        }
        return d1;
    }

    public static Complex[] ifft(Complex[] z) {
        int exp = 0;
        int m = 2;
        int n = z.length;
        do {
            ++exp;
        } while ((m = 2 * m) < z.length);
        if (m != z.length) {
            String s = "Invalid FFT array size: " + z.length;
            throw new InvalidArraySizeException(s);
        }
        double[] x = new double[n];
        double[] y = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = z[i].re();
            y[i] = z[i].im();
            ++i;
        }
        SigProc.fftCore((double[])x, (double[])y, (boolean)true);
        Complex[] z1 = new Complex[z.length];
        i = 0;
        while (i < n) {
            z1[i] = new Complex(x[i], y[i]);
            ++i;
        }
        return z1;
    }

    public static Complex[] ifft(Complex[] z, int size) {
        int exp = 0;
        int m = 2;
        int n = size;
        do {
            ++exp;
        } while ((m = 2 * m) < size);
        if (m != size) {
            String s = "Invalid FFT array size: " + size;
            throw new InvalidArraySizeException(s);
        }
        double[] x = new double[n];
        double[] y = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = z[i].re();
            y[i] = z[i].im();
            ++i;
        }
        SigProc.fftCore((double[])x, (double[])y, (boolean)true);
        Complex[] z1 = new Complex[size];
        i = 0;
        while (i < n) {
            z1[i] = new Complex(x[i], y[i]);
            ++i;
        }
        return z1;
    }

    public static int nextMul(int arraySize) {
        int exp = 0;
        int m = 2;
        do {
            ++exp;
        } while ((m = 2 * m) < arraySize);
        return m;
    }

    public static double[] calcLags(double[] xa, double[] xb) {
        double[] lags = new double[xa.length + xb.length - 1];
        int k = -xa.length + 1;
        int i = 0;
        while (i < xa.length + xb.length - 1) {
            lags[i] = k++;
            ++i;
        }
        return lags;
    }

    public static double[] calcLags(Complex[] za, Complex[] zb) {
        double[] lags = new double[za.length + zb.length - 1];
        int k = -za.length + 1;
        int i = 0;
        while (i < za.length + zb.length - 1) {
            lags[i] = k++;
            ++i;
        }
        return lags;
    }

    private static Complex[] convCore(Complex[] za, Complex[] zb) {
        int fftSize = SigProc.nextMul((int)(za.length + zb.length));
        double[] xa = new double[fftSize];
        double[] xb = new double[fftSize];
        double[] ya = new double[fftSize];
        double[] yb = new double[fftSize];
        int i = 0;
        while (i < za.length) {
            xa[i] = za[i].re();
            ya[i] = za[i].im();
            ++i;
        }
        i = 0;
        while (i < zb.length) {
            xb[i] = zb[i].re();
            yb[i] = zb[i].im();
            ++i;
        }
        i = za.length;
        while (i < fftSize) {
            xa[i] = 0.0;
            ya[i] = 0.0;
            ++i;
        }
        i = zb.length;
        while (i < fftSize) {
            xb[i] = 0.0;
            yb[i] = 0.0;
            ++i;
        }
        SigProc.fftCore((double[])xa, (double[])ya, (boolean)false);
        SigProc.fftCore((double[])xb, (double[])yb, (boolean)false);
        i = 0;
        while (i < fftSize) {
            double xt = xa[i] * xb[i] - ya[i] * yb[i];
            double yt = xa[i] * yb[i] + xb[i] * ya[i];
            xa[i] = xt;
            ya[i] = yt;
            ++i;
        }
        SigProc.fftCore((double[])xa, (double[])ya, (boolean)true);
        Complex[] zout = new Complex[za.length + zb.length - 1];
        i = 0;
        while (i < za.length + zb.length - 1) {
            zout[i] = new Complex(xa[i], ya[i]);
            ++i;
        }
        return zout;
    }

    private static double[] correlCore(double[] za, double[] zb, int norm) {
        int fftSize = SigProc.nextMul((int)(2 * Math.max(za.length, zb.length)));
        double[] xa = new double[fftSize];
        double[] xb = new double[fftSize];
        double[] ya = new double[fftSize];
        double[] yb = new double[fftSize];
        double dena = 0.0;
        int i = 0;
        while (i < za.length) {
            xa[i] = za[i];
            ya[i] = 0.0;
            dena += xa[i] * xa[i];
            ++i;
        }
        double denb = 0.0;
        i = 0;
        while (i < zb.length) {
            xb[i] = zb[i];
            yb[i] = 0.0;
            denb += xb[i] * xb[i];
            ++i;
        }
        double scale = norm == 1 && dena != 0.0 && denb != 0.0 ? 1.0 / Math.sqrt(dena * denb) : 1.0;
        i = za.length;
        while (i < fftSize) {
            xa[i] = 0.0;
            ya[i] = 0.0;
            ++i;
        }
        i = zb.length;
        while (i < fftSize) {
            xb[i] = 0.0;
            yb[i] = 0.0;
            ++i;
        }
        SigProc.fftCore((double[])xa, (double[])ya, (boolean)false);
        SigProc.fftCore((double[])xb, (double[])yb, (boolean)false);
        i = 0;
        while (i < fftSize) {
            double xt = xa[i] * xb[i] + ya[i] * yb[i];
            double yt = xa[i] * yb[i] - xb[i] * ya[i];
            xa[i] = xt;
            ya[i] = yt;
            ++i;
        }
        SigProc.fftCore((double[])xa, (double[])ya, (boolean)true);
        double[] zout = new double[za.length + zb.length - 1];
        int k = 0;
        if (norm == 1) {
            i = xa.length - za.length + 1;
            while (i < xa.length) {
                zout[k++] = xa[i] * scale;
                ++i;
            }
            i = 0;
            while (i < zb.length) {
                zout[k++] = xa[i] * scale;
                ++i;
            }
        } else {
            i = xa.length - za.length + 1;
            while (i < xa.length) {
                zout[k++] = xa[i];
                ++i;
            }
            i = 0;
            while (i < zb.length) {
                zout[k++] = xa[i];
                ++i;
            }
        }
        return zout;
    }

    private static Complex[] correlCore(Complex[] za, Complex[] zb, int norm) {
        int fftSize = SigProc.nextMul((int)(za.length + zb.length));
        double[] xa = new double[fftSize];
        double[] xb = new double[fftSize];
        double[] ya = new double[fftSize];
        double[] yb = new double[fftSize];
        double dena = 0.0;
        int i = 0;
        while (i < za.length) {
            xa[i] = za[i].re();
            ya[i] = za[i].im();
            dena += xa[i] * xa[i] + ya[i] * ya[i];
            ++i;
        }
        double denb = 0.0;
        i = 0;
        while (i < zb.length) {
            xb[i] = zb[i].re();
            yb[i] = zb[i].im();
            denb += xb[i] * xb[i] + yb[i] * yb[i];
            ++i;
        }
        double scale = norm == 1 && dena != 0.0 && denb != 0.0 ? 1.0 / Math.sqrt(dena * denb) : 1.0;
        i = za.length;
        while (i < fftSize) {
            xa[i] = 0.0;
            ya[i] = 0.0;
            ++i;
        }
        i = zb.length;
        while (i < fftSize) {
            xb[i] = 0.0;
            yb[i] = 0.0;
            ++i;
        }
        SigProc.fftCore((double[])xa, (double[])ya, (boolean)false);
        SigProc.fftCore((double[])xb, (double[])yb, (boolean)false);
        i = 0;
        while (i < fftSize) {
            double xt = xa[i] * xb[i] + ya[i] * yb[i];
            double yt = xa[i] * yb[i] - xb[i] * ya[i];
            xa[i] = xt;
            ya[i] = yt;
            ++i;
        }
        SigProc.fftCore((double[])xa, (double[])ya, (boolean)true);
        Complex[] zout = new Complex[za.length + zb.length - 1];
        int k = 0;
        if (norm == 1) {
            i = xa.length - za.length + 1;
            while (i < xa.length) {
                zout[k++] = new Complex(xa[i] * scale, ya[i] * scale);
                ++i;
            }
            i = 0;
            while (i < zb.length) {
                zout[k++] = new Complex(xa[i] * scale, ya[i] * scale);
                ++i;
            }
        } else {
            i = xa.length - za.length + 1;
            while (i < xa.length) {
                zout[k++] = new Complex(xa[i], ya[i]);
                ++i;
            }
            i = 0;
            while (i < zb.length) {
                zout[k++] = new Complex(xa[i], ya[i]);
                ++i;
            }
        }
        return zout;
    }

    private static void fftCore(double[] x, double[] y, boolean inv) {
        double yt;
        double xt;
        int i;
        int j;
        int n1;
        int exp = 0;
        int m = 2;
        int n = x.length;
        do {
            ++exp;
        } while ((m = 2 * m) < x.length);
        int n2 = n;
        int k = 1;
        while (k <= m) {
            n1 = n2;
            n2 /= 2;
            double e = Math.PI * 2 / (double)n1;
            double a = 0.0;
            j = 1;
            while (j <= n2) {
                double sina;
                double cosa;
                if (inv) {
                    cosa = Math.cos(a);
                    sina = Math.sin(a);
                } else {
                    cosa = Math.cos(a);
                    sina = -Math.sin(a);
                }
                a = (double)j * e;
                i = j;
                while (i <= n) {
                    int l = i + n2;
                    xt = x[i - 1] - x[l - 1];
                    x[i - 1] = x[i - 1] + x[l - 1];
                    yt = y[i - 1] - y[l - 1];
                    y[i - 1] = y[i - 1] + y[l - 1];
                    x[l - 1] = xt * cosa - yt * sina;
                    y[l - 1] = xt * sina + yt * cosa;
                    i += n1;
                }
                ++j;
            }
            ++k;
        }
        j = 1;
        n1 = n - 1;
        i = 1;
        while (i <= n1) {
            if (i < j) {
                xt = x[j - 1];
                x[j - 1] = x[i - 1];
                yt = y[j - 1];
                y[j - 1] = y[i - 1];
                x[i - 1] = xt;
                y[i - 1] = yt;
            }
            k = n / 2;
            while (k < j) {
                j -= k;
                k /= 2;
            }
            j += k;
            ++i;
        }
        if (inv) {
            i = 0;
            while (i < n) {
                x[i] = x[i] / (double)n;
                y[i] = y[i] / (double)n;
                ++i;
            }
        }
    }
}

