/*
 * Decompiled with CFR 0.152.
 */
package chapman.math;

import java.util.Random;

public final class Math1 {
    public static final double DEG_2_RAD = Math.PI / 180;
    public static final double RAD_2_DEG = 57.29577951308232;
    private static final double LOGE_10 = 2.302585092994046;
    private static Random randomNumberGenerator;

    private Math1() {
    }

    public static synchronized double acosd(double a) {
        return Math.acos(a) * 57.29577951308232;
    }

    public static synchronized double acosh(double a) {
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static synchronized double asind(double a) {
        return Math.asin(a) * 57.29577951308232;
    }

    public static synchronized double asinh(double a) {
        return Math.log(a + Math.sqrt(1.0 + a * a));
    }

    public static synchronized double atand(double a) {
        return Math.atan(a) * 57.29577951308232;
    }

    public static synchronized double atanh(double a) {
        return 0.5 * Math.log((1.0 + a) / (1.0 - a));
    }

    public static synchronized double atan2d(double a, double b) {
        return Math.atan2(a, b) * 57.29577951308232;
    }

    public static synchronized double cosd(double a) {
        return Math.cos(a * (Math.PI / 180));
    }

    public static synchronized double cosh(double a) {
        return (Math.exp(a) + Math.exp(-a)) / 2.0;
    }

    public static synchronized double log10(double a) {
        return Math.log(a) / 2.302585092994046;
    }

    public static synchronized double randomGaussian() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator.nextGaussian();
    }

    public static synchronized double randomRayleigh() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        double x = randomNumberGenerator.nextGaussian();
        double y = randomNumberGenerator.nextGaussian();
        return Math.sqrt(x * x + y * y);
    }

    public static synchronized double sinc(double x) {
        if (Math.abs(x) < 1.0E-30) {
            return 1.0;
        }
        return Math.sin(x) / x;
    }

    public static synchronized double sind(double a) {
        return Math.sin(a * (Math.PI / 180));
    }

    public static synchronized double sinh(double a) {
        return (Math.exp(a) - Math.exp(-a)) / 2.0;
    }

    public static synchronized double tand(double a) {
        return Math.tan(a * (Math.PI / 180));
    }

    public static synchronized double tanh(double a) {
        double exp = Math.exp(a);
        double exm = Math.exp(-a);
        return (exp - exm) / (exp + exm);
    }
}

