/*
 * Decompiled with CFR 0.152.
 */
package chapman.math;

import java.io.Serializable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Complex
extends Number
implements Cloneable,
Serializable,
Comparable {
    private static final double TWO_PI = Math.PI * 2;
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex J = new Complex(0.0, 1.0);
    private double re;
    private double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public Complex(Complex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public byte byteValue() {
        return (byte)Math.floor(this.re + 0.5);
    }

    public double doubleValue() {
        return this.re;
    }

    public float floatValue() {
        return (float)this.re;
    }

    public int intValue() {
        return (int)Math.floor(this.re + 0.5);
    }

    public long longValue() {
        return (long)Math.floor(this.re + 0.5);
    }

    public short shortValue() {
        return (short)Math.floor(this.re + 0.5);
    }

    public String toString() {
        if (this.im < 0.0) {
            return "(" + this.re + " - i " + -this.im + ")";
        }
        if (1.0 / this.im == Double.NEGATIVE_INFINITY) {
            return "(" + this.re + " + i " + 0.0 + ")";
        }
        return "(" + this.re + " + i " + this.im + ")";
    }

    public static double abs(Complex z) {
        double absRe = Math.abs(z.re);
        double absIm = Math.abs(z.im);
        if (absRe == 0.0 && absIm == 0.0) {
            return 0.0;
        }
        if (absRe >= absIm) {
            double d = z.im / z.re;
            return absRe * Math.sqrt(1.0 + d * d);
        }
        double d = z.re / z.im;
        return absIm * Math.sqrt(1.0 + d * d);
    }

    public static double arg(Complex z) {
        return Math.atan2(z.im, z.re);
    }

    public static Complex acos(Complex z) {
        double im3;
        double re1 = 1.0 - (z.re * z.re - z.im * z.im);
        double im1 = 0.0 - (z.re * z.im + z.im * z.re);
        Complex result = Complex.complex((double)re1, (double)im1);
        Complex.sqrt1((Complex)result);
        double re2 = -result.im;
        double im2 = result.re;
        result.re = z.re + re2;
        result.im = z.im + im2;
        double re3 = Math.log(Complex.abs((Complex)result));
        result.re = im3 = Complex.arg((Complex)result);
        result.im = -re3;
        return result;
    }

    public static Complex acosh(Complex z) {
        double re1 = z.re * z.re - z.im * z.im - 1.0;
        double im1 = z.re * z.im + z.im * z.re;
        Complex result = Complex.complex((double)re1, (double)im1);
        Complex.sqrt1((Complex)result);
        result.re = z.re + result.re;
        result.im = z.im + result.im;
        double re2 = Math.log(Complex.abs((Complex)result));
        double im2 = Complex.arg((Complex)result);
        result.re = re2;
        result.im = im2;
        return result;
    }

    public static Complex asin(Complex z) {
        double im3;
        double re1 = 1.0 - (z.re * z.re - z.im * z.im);
        double im1 = 0.0 - (z.re * z.im + z.im * z.re);
        Complex result = Complex.complex((double)re1, (double)im1);
        Complex.sqrt1((Complex)result);
        double re2 = -z.im;
        double im2 = z.re;
        result.re = re2 + result.re;
        result.im = im2 + result.im;
        double re3 = Math.log(Complex.abs((Complex)result));
        result.re = im3 = Complex.arg((Complex)result);
        result.im = -re3;
        return result;
    }

    public static Complex asinh(Complex z) {
        double re1 = z.re * z.re - z.im * z.im + 1.0;
        double im1 = z.re * z.im + z.im * z.re;
        Complex result = Complex.complex((double)re1, (double)im1);
        Complex.sqrt1((Complex)result);
        result.re = z.re + result.re;
        result.im = z.im + result.im;
        double re2 = Math.log(result.abs());
        double im2 = result.arg();
        result.re = re2;
        result.im = im2;
        return result;
    }

    public static Complex atan(Complex z) {
        Complex result = Complex.complex((double)(-z.re), (double)(1.0 - z.im));
        double re1 = z.re;
        double im1 = 1.0 + z.im;
        Complex.div((Complex)result, (double)re1, (double)im1);
        double re2 = Math.log(Complex.abs((Complex)result));
        double im2 = Complex.arg((Complex)result);
        result.re = 0.5 * im2;
        result.im = -0.5 * re2;
        return result;
    }

    public static Complex atanh(Complex z) {
        Complex result = Complex.complex((double)(1.0 + z.re), (double)z.im);
        double re1 = 1.0 - z.re;
        double im1 = -z.im;
        Complex.div((Complex)result, (double)re1, (double)im1);
        double re2 = Math.log(Complex.abs((Complex)result));
        double im2 = Complex.arg((Complex)result);
        result.re = 0.5 * re2;
        result.im = 0.5 * im2;
        return result;
    }

    public static Complex complex(double re) {
        return new Complex(re, 0.0);
    }

    public static Complex complex(double re, double im) {
        return new Complex(re, im);
    }

    public static Complex conj(Complex z) {
        return Complex.complex((double)z.re, (double)(-z.im));
    }

    public static Complex cos(Complex z) {
        double izRe = -z.im;
        double izIm = z.re;
        double scalar = Math.exp(izRe);
        double re1 = scalar * Math.cos(izIm);
        double im1 = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        double re2 = scalar * Math.cos(-izIm);
        double im2 = scalar * Math.sin(-izIm);
        return Complex.complex((double)(0.5 * (re1 += re2)), (double)(0.5 * (im1 += im2)));
    }

    public static Complex cosh(Complex z) {
        double scalar = Math.exp(z.re);
        double re1 = scalar * Math.cos(z.im);
        double im1 = scalar * Math.sin(z.im);
        scalar = Math.exp(-z.re);
        double re2 = scalar * Math.cos(-z.im);
        double im2 = scalar * Math.sin(-z.im);
        return Complex.complex((double)(0.5 * (re1 += re2)), (double)(0.5 * (im1 += im2)));
    }

    public static Complex exp(Complex z) {
        double scalar = Math.exp(z.re);
        return Complex.complex((double)(scalar * Math.cos(z.im)), (double)(scalar * Math.sin(z.im)));
    }

    public static double im(Complex z) {
        return z.im;
    }

    public static Complex inv(Complex z) {
        double zIm;
        double zRe;
        double x = z.re;
        double y = z.im;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar;
            zRe = scalar = 1.0 / (x + y * (y / x));
            zIm = -scalar * (y / x);
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            zRe = scalar * (x / y);
            zIm = -scalar;
        }
        return Complex.complex((double)zRe, (double)zIm);
    }

    public static Complex log(Complex z) {
        return Complex.complex((double)Math.log(Complex.abs((Complex)z)), (double)Complex.arg((Complex)z));
    }

    public static double norm(Complex z) {
        return z.re * z.re + z.im * z.im;
    }

    public static double phase(Complex c) {
        return Math.atan2(c.im, c.re);
    }

    public static Complex polar(double r, double theta) {
        if (r < 0.0) {
            theta += Math.PI;
            r = -r;
        }
        return Complex.complex((double)(r * Math.cos(theta %= Math.PI * 2)), (double)(r * Math.sin(theta)));
    }

    public static Complex pow(Complex base, double exponent) {
        double re = exponent * Math.log(base.abs());
        double im = exponent * base.arg();
        double scalar = Math.exp(re);
        return Complex.complex((double)(scalar * Math.cos(im)), (double)(scalar * Math.sin(im)));
    }

    public static Complex pow(double base, Complex exponent) {
        double re = Math.log(Math.abs(base));
        double im = Math.atan2(0.0, base);
        double re2 = re * exponent.re - im * exponent.im;
        double im2 = re * exponent.im + im * exponent.re;
        double scalar = Math.exp(re2);
        return Complex.complex((double)(scalar * Math.cos(im2)), (double)(scalar * Math.sin(im2)));
    }

    public static Complex pow(Complex base, Complex exponent) {
        double re = Math.log(base.abs());
        double im = base.arg();
        double re2 = re * exponent.re - im * exponent.im;
        double im2 = re * exponent.im + im * exponent.re;
        double scalar = Math.exp(re2);
        return Complex.complex((double)(scalar * Math.cos(im2)), (double)(scalar * Math.sin(im2)));
    }

    public static double re(Complex z) {
        return z.re;
    }

    public static Complex sin(Complex z) {
        double izRe = -z.im;
        double izIm = z.re;
        double scalar = Math.exp(izRe);
        double re1 = scalar * Math.cos(izIm);
        double im1 = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        double re2 = scalar * Math.cos(-izIm);
        double im2 = scalar * Math.sin(-izIm);
        return Complex.complex((double)(0.5 * (im1 -= im2)), (double)(-0.5 * (re1 -= re2)));
    }

    public static Complex sinh(Complex z) {
        double scalar = Math.exp(z.re);
        double re1 = scalar * Math.cos(z.im);
        double im1 = scalar * Math.sin(z.im);
        scalar = Math.exp(-z.re);
        double re2 = scalar * Math.cos(-z.im);
        double im2 = scalar * Math.sin(-z.im);
        return Complex.complex((double)(0.5 * (re1 -= re2)), (double)(0.5 * (im1 -= im2)));
    }

    public static Complex sqrt(Complex z) {
        double re = 0.0;
        double im = 0.0;
        double u = 0.0;
        double v = 0.0;
        double mag = z.abs();
        if (mag > 0.0) {
            if (z.re > 0.0) {
                double temp;
                re = temp = Math.sqrt(0.5 * (mag + z.re));
                im = 0.5 * z.im / temp;
            } else {
                double temp = Math.sqrt(0.5 * (mag - z.re));
                if (z.im < 0.0) {
                    temp = -temp;
                }
                re = 0.5 * z.im / temp;
                im = temp;
            }
        } else {
            re = 0.0;
            im = 0.0;
        }
        return Complex.complex((double)re, (double)im);
    }

    public static Complex tan(Complex z) {
        double izRe = -z.im;
        double izIm = z.re;
        double scalar = Math.exp(izRe);
        double re1 = scalar * Math.cos(izIm);
        double im1 = scalar * Math.sin(izIm);
        scalar = Math.exp(-izRe);
        double re2 = scalar * Math.cos(-izIm);
        double im2 = scalar * Math.sin(-izIm);
        double re3 = re1 - re2;
        double im3 = im1 - im2;
        Complex result = Complex.complex((double)(0.5 * im3), (double)(-0.5 * re3));
        double re4 = re1 + re2;
        double im4 = im1 + im2;
        double cosRe = 0.5 * re4;
        double cosIm = 0.5 * im4;
        Complex.div((Complex)result, (double)cosRe, (double)cosIm);
        return result;
    }

    public static Complex tanh(Complex z) {
        double scalar = Math.exp(z.re);
        double re1 = scalar * Math.cos(z.im);
        double im1 = scalar * Math.sin(z.im);
        scalar = Math.exp(-z.re);
        double re2 = scalar * Math.cos(-z.im);
        double im2 = scalar * Math.sin(-z.im);
        double re3 = re1 - re2;
        double im3 = im1 - im2;
        double re4 = re1 + re2;
        double im4 = im1 + im2;
        Complex result = Complex.complex((double)re3, (double)im3);
        Complex.div((Complex)result, (double)re4, (double)im4);
        return result;
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public void setIm(double im) {
        this.im = im;
    }

    public void setRe(double re) {
        this.re = re;
    }

    public void setZ(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public double abs() {
        double absRe = Math.abs(this.re);
        double absIm = Math.abs(this.im);
        if (absRe == 0.0 && absIm == 0.0) {
            return 0.0;
        }
        if (absRe >= absIm) {
            double d = this.im / this.re;
            return absRe * Math.sqrt(1.0 + d * d);
        }
        double d = this.re / this.im;
        return absIm * Math.sqrt(1.0 + d * d);
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex conj() {
        return Complex.complex((double)this.re, (double)(-this.im));
    }

    public Complex add(Complex z) {
        return Complex.complex((double)(this.re + z.re), (double)(this.im + z.im));
    }

    public Complex add(double d) {
        return Complex.complex((double)(this.re + d), (double)this.im);
    }

    public Complex sub(Complex z) {
        return Complex.complex((double)(this.re - z.re), (double)(this.im - z.im));
    }

    public Complex sub(double d) {
        return Complex.complex((double)(this.re - d), (double)this.im);
    }

    public Complex mul(Complex z) {
        return Complex.complex((double)(this.re * z.re - this.im * z.im), (double)(this.re * z.im + this.im * z.re));
    }

    public Complex mul(double d) {
        return Complex.complex((double)(this.re * d), (double)(this.im * d));
    }

    public Complex div(Complex z) {
        double zIm;
        double zRe;
        double x = z.re;
        double y = z.im;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar = 1.0 / (x + y * (y / x));
            zRe = scalar * (this.re + this.im * (y / x));
            zIm = scalar * (this.im - this.re * (y / x));
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            zRe = scalar * (this.re * (x / y) + this.im);
            zIm = scalar * (this.im * (x / y) - this.re);
        }
        return Complex.complex((double)zRe, (double)zIm);
    }

    public Complex div(double d) {
        return Complex.complex((double)(this.re / d), (double)(this.im / d));
    }

    public Complex inv() {
        double zIm;
        double zRe;
        double x = this.re;
        double y = this.im;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar;
            zRe = scalar = 1.0 / (x + y * (y / x));
            zIm = -scalar * (y / x);
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            zRe = scalar * (x / y);
            zIm = -scalar;
        }
        return Complex.complex((double)zRe, (double)zIm);
    }

    public Complex neg() {
        return Complex.complex((double)(-this.re), (double)(-this.im));
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public Complex pow(double exponent) {
        double re = exponent * Math.log(this.abs());
        double im = exponent * this.arg();
        double scalar = Math.exp(re);
        return Complex.complex((double)(scalar * Math.cos(im)), (double)(scalar * Math.sin(im)));
    }

    public Complex pow(Complex exponent) {
        double re = Math.log(this.abs());
        double im = this.arg();
        double re2 = re * exponent.re - im * exponent.im;
        double im2 = re * exponent.im + im * exponent.re;
        double scalar = Math.exp(re2);
        return Complex.complex((double)(scalar * Math.cos(im2)), (double)(scalar * Math.sin(im2)));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean equals(Complex z) {
        double tol1 = 1.0E-13 * Complex.abs((Complex)this);
        return this.re - z.re <= tol1 && this.im - z.im <= tol1;
    }

    public boolean equals(Complex z, double tol) {
        double tol1 = Math.abs(tol) * Complex.abs((Complex)this);
        return this.re - z.re <= tol1 && this.im - z.im <= tol1;
    }

    public int compareTo(Complex anotherComplex) {
        double anotherVal;
        double thisVal = this.abs();
        return thisVal < (anotherVal = anotherComplex.abs()) ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public int compareTo(Object o) {
        return this.compareTo((Complex)o);
    }

    private static void div(Complex z, double x, double y) {
        double zIm;
        double zRe;
        if (Math.abs(x) >= Math.abs(y)) {
            double scalar = 1.0 / (x + y * (y / x));
            zRe = scalar * (z.re + z.im * (y / x));
            zIm = scalar * (z.im - z.re * (y / x));
        } else {
            double scalar = 1.0 / (x * (x / y) + y);
            zRe = scalar * (z.re * (x / y) + z.im);
            zIm = scalar * (z.im * (x / y) - z.re);
        }
        z.re = zRe;
        z.im = zIm;
    }

    private static void sqrt1(Complex z) {
        double re = 0.0;
        double im = 0.0;
        double u = 0.0;
        double v = 0.0;
        double mag = z.abs();
        if (mag > 0.0) {
            if (z.re > 0.0) {
                double temp;
                re = temp = Math.sqrt(0.5 * (mag + z.re));
                im = 0.5 * z.im / temp;
            } else {
                double temp = Math.sqrt(0.5 * (mag - z.re));
                if (z.im < 0.0) {
                    temp = -temp;
                }
                re = 0.5 * z.im / temp;
                im = temp;
            }
        } else {
            re = 0.0;
            im = 0.0;
        }
        z.re = re;
        z.im = im;
    }
}

