/*
 * Decompiled with CFR 0.152.
 */
package chapman.io;

public class Fmt {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leading_zeroes = false;
    private boolean show_plus = false;
    private boolean alternate = false;
    private boolean show_space = false;
    private boolean left_align = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Fmt(String s) {
        boolean state = false;
        int length = s.length();
        int parse_state = 0;
        int i = 0;
        while (parse_state == 0) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == '%') {
                if (i >= length - 1) throw new IllegalArgumentException();
                if (s.charAt(i + 1) == '%') {
                    this.pre = this.pre + '%';
                    ++i;
                } else {
                    parse_state = 1;
                }
            } else {
                this.pre = this.pre + s.charAt(i);
            }
            ++i;
        }
        while (parse_state == 1) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == ' ') {
                this.show_space = true;
            } else if (s.charAt(i) == '-') {
                this.left_align = true;
            } else if (s.charAt(i) == '+') {
                this.show_plus = true;
            } else if (s.charAt(i) == '0') {
                this.leading_zeroes = true;
            } else if (s.charAt(i) == '#') {
                this.alternate = true;
            } else {
                parse_state = 2;
                --i;
            }
            ++i;
        }
        while (parse_state == 2) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parse_state = 3;
                this.precision = 0;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        while (parse_state == 3) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        if (parse_state == 4) {
            if (i >= length) {
                parse_state = 5;
            } else {
                this.fmt = s.charAt(i);
            }
            ++i;
        }
        if (i >= length) return;
        this.post = s.substring(i, length);
    }

    public static void printf(String fmt, double x) {
        System.out.print(new Fmt(fmt).form(x));
    }

    public static void printf(String fmt, long l) {
        System.out.print(new Fmt(fmt).form(l));
    }

    public static void printf(String fmt, char c) {
        System.out.print(new Fmt(fmt).form(c));
    }

    public static void printf(String fmt, String s) {
        System.out.print(new Fmt(fmt).form(s));
    }

    public static String sprintf(String fmt, double x) {
        return new Fmt(fmt).form(x);
    }

    public static String sprintf(String fmt, long l) {
        return new Fmt(fmt).form(l);
    }

    public static String sprintf(String fmt, char c) {
        return new Fmt(fmt).form(c);
    }

    public static String sprintf(String fmt, String s) {
        return new Fmt(fmt).form(s);
    }

    public static void main(String[] a) {
        double x = 1.23456789012;
        double y = 123.0;
        double z = 1.2345E30;
        double w = 1.02;
        double u = 1.234E-5;
        int d = 51966;
        System.out.println("printf methods:");
        Fmt.printf("x = |%f|\n", x);
        Fmt.printf("u = |%20f|\n", u);
        Fmt.printf("x = |% .5f|\n", x);
        Fmt.printf("w = |%20.5f|\n", w);
        Fmt.printf("x = |%020.5f|\n", x);
        Fmt.printf("x = |%+20.5f|\n", x);
        Fmt.printf("x = |%+020.5f|\n", x);
        Fmt.printf("x = |% 020.5f|\n", x);
        Fmt.printf("y = |%#+20.5f|\n", y);
        Fmt.printf("y = |%-+20.5f|\n", y);
        Fmt.printf("z = |%20.5f|\n", z);
        Fmt.printf("x = |%e|\n", x);
        Fmt.printf("u = |%20e|\n", u);
        Fmt.printf("x = |% .5e|\n", x);
        Fmt.printf("w = |%20.5e|\n", w);
        Fmt.printf("x = |%020.5e|\n", x);
        Fmt.printf("x = |%+20.5e|\n", x);
        Fmt.printf("x = |%+020.5e|\n", x);
        Fmt.printf("x = |% 020.5e|\n", x);
        Fmt.printf("y = |%#+20.5e|\n", y);
        Fmt.printf("y = |%-+20.5e|\n", y);
        Fmt.printf("x = |%g|\n", x);
        Fmt.printf("z = |%g|\n", z);
        Fmt.printf("w = |%g|\n", w);
        Fmt.printf("u = |%g|\n", u);
        Fmt.printf("y = |%.2g|\n", y);
        Fmt.printf("y = |%#.2g|\n", y);
        Fmt.printf("d = |%d|\n", d);
        Fmt.printf("d = |%20d|\n", d);
        Fmt.printf("d = |%020d|\n", d);
        Fmt.printf("d = |%+20d|\n", d);
        Fmt.printf("d = |% 020d|\n", d);
        Fmt.printf("d = |%-20d|\n", d);
        Fmt.printf("d = |%20.8d|\n", d);
        Fmt.printf("d = |%x|\n", d);
        Fmt.printf("d = |%20X|\n", d);
        Fmt.printf("d = |%#20x|\n", d);
        Fmt.printf("d = |%020X|\n", d);
        Fmt.printf("d = |%20.8x|\n", d);
        Fmt.printf("d = |%o|\n", d);
        Fmt.printf("d = |%020o|\n", d);
        Fmt.printf("d = |%#20o|\n", d);
        Fmt.printf("d = |%#020o|\n", d);
        Fmt.printf("d = |%20.12o|\n", d);
        Fmt.printf("s = |%-20s|\n", "Hello");
        Fmt.printf("s = |%-20c|\n", '!');
        System.out.println("\nsprintf methods:");
        System.out.print(Fmt.sprintf("x = |%f|\n", x));
        System.out.print(Fmt.sprintf("u = |%20f|\n", u));
        System.out.print(Fmt.sprintf("x = |% .5f|\n", x));
        System.out.print(Fmt.sprintf("w = |%20.5f|\n", w));
        System.out.print(Fmt.sprintf("x = |%020.5f|\n", x));
        System.out.print(Fmt.sprintf("x = |%+20.5f|\n", x));
        System.out.print(Fmt.sprintf("x = |%+020.5f|\n", x));
        System.out.print(Fmt.sprintf("x = |% 020.5f|\n", x));
        System.out.print(Fmt.sprintf("y = |%#+20.5f|\n", y));
        System.out.print(Fmt.sprintf("y = |%-+20.5f|\n", y));
        System.out.print(Fmt.sprintf("z = |%20.5f|\n", z));
        System.out.print(Fmt.sprintf("x = |%e|\n", x));
        System.out.print(Fmt.sprintf("u = |%20e|\n", u));
        System.out.print(Fmt.sprintf("x = |% .5e|\n", x));
        System.out.print(Fmt.sprintf("w = |%20.5e|\n", w));
        System.out.print(Fmt.sprintf("x = |%020.5e|\n", x));
        System.out.print(Fmt.sprintf("x = |%+20.5e|\n", x));
        System.out.print(Fmt.sprintf("x = |%+020.5e|\n", x));
        System.out.print(Fmt.sprintf("x = |% 020.5e|\n", x));
        System.out.print(Fmt.sprintf("y = |%#+20.5e|\n", y));
        System.out.print(Fmt.sprintf("y = |%-+20.5e|\n", y));
        System.out.print(Fmt.sprintf("x = |%g|\n", x));
        System.out.print(Fmt.sprintf("z = |%g|\n", z));
        System.out.print(Fmt.sprintf("w = |%g|\n", w));
        System.out.print(Fmt.sprintf("u = |%g|\n", u));
        System.out.print(Fmt.sprintf("y = |%.2g|\n", y));
        System.out.print(Fmt.sprintf("y = |%#.2g|\n", y));
        System.out.print(Fmt.sprintf("d = |%d|\n", d));
        System.out.print(Fmt.sprintf("d = |%20d|\n", d));
        System.out.print(Fmt.sprintf("d = |%020d|\n", d));
        System.out.print(Fmt.sprintf("d = |%+20d|\n", d));
        System.out.print(Fmt.sprintf("d = |% 020d|\n", d));
        System.out.print(Fmt.sprintf("d = |%-20d|\n", d));
        System.out.print(Fmt.sprintf("d = |%20.8d|\n", d));
        System.out.print(Fmt.sprintf("d = |%x|\n", d));
        System.out.print(Fmt.sprintf("d = |%20X|\n", d));
        System.out.print(Fmt.sprintf("d = |%#20x|\n", d));
        System.out.print(Fmt.sprintf("d = |%020X|\n", d));
        System.out.print(Fmt.sprintf("d = |%20.8x|\n", d));
        System.out.print(Fmt.sprintf("d = |%o|\n", d));
        System.out.print(Fmt.sprintf("d = |%020o|\n", d));
        System.out.print(Fmt.sprintf("d = |%#20o|\n", d));
        System.out.print(Fmt.sprintf("d = |%#020o|\n", d));
        System.out.print(Fmt.sprintf("d = |%20.12o|\n", d));
        System.out.print(Fmt.sprintf("s = |%-20s|\n", "Hello"));
        System.out.print(Fmt.sprintf("s = |%-20c|\n", '!'));
    }

    private String form(double x) {
        String r;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        if (this.fmt == 'f') {
            r = this.fixed_format(x);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.exp_format(x);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    private String form(long x) {
        String r;
        int s = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            s = 1;
            if (x < 0L) {
                x = -x;
                s = -1;
            }
            r = "" + x;
        } else if (this.fmt == 'o') {
            r = Fmt.convert(x, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            r = Fmt.convert(x, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            r = Fmt.convert(x, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    private String form(char c) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String r = "" + c;
        return this.pad(r);
    }

    private String form(String s) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    private static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer(n);
        int i = 0;
        while (i < n) {
            s.append(c);
            ++i;
        }
        return s.toString();
    }

    private static String convert(long x, int n, int m, String d) {
        if (x == 0L) {
            return "0";
        }
        String r = "";
        while (x != 0L) {
            r = d.charAt((int)(x & (long)m)) + r;
            x >>>= n;
        }
        return r;
    }

    private String pad(String r) {
        String p = Fmt.repeat(' ', this.width - r.length());
        if (this.left_align) {
            return this.pre + r + p + this.post;
        }
        return this.pre + p + r + this.post;
    }

    private String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.show_plus) {
                p = "+";
            } else if (this.show_space) {
                p = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && r.length() > 0 && r.charAt(0) != '0') {
            p = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            p = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            p = "0X";
        }
        int w = 0;
        if (this.leading_zeroes) {
            w = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        return p + Fmt.repeat('0', w - p.length() - r.length()) + r;
    }

    private String fixed_format(double d) {
        String f = "";
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        double factor = Math.pow(10.0, this.precision);
        long l = (long)(factor * (d + 0.5 / factor));
        StringBuffer sb = new StringBuffer(f + l);
        if (sb.length() - this.precision < 1) {
            int endValue = this.precision - sb.length() + 1;
            int i = 1;
            while (i <= endValue) {
                sb.insert(0, '0');
                ++i;
            }
        }
        sb.insert(sb.length() - this.precision, '.');
        f = sb.toString();
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int t = f.length() - 1;
            while (t >= 0 && f.charAt(t) == '0') {
                --t;
            }
            if (t >= 0 && f.charAt(t) == '.') {
                --t;
            }
            f = f.substring(0, t + 1);
        }
        return f;
    }

    private String frac_part(double fr) {
        String z = "";
        if (this.precision > 0) {
            double factor = 1.0;
            String leading_zeroes = "";
            int i = 1;
            while (i <= this.precision && factor <= 9.223372036854776E18) {
                factor *= 10.0;
                leading_zeroes = leading_zeroes + "0";
                ++i;
            }
            long l = (long)(factor * fr + 0.5);
            z = leading_zeroes + l;
            z = z.substring(z.length() - this.precision, z.length());
        }
        if (this.precision > 0 || this.alternate) {
            z = "." + z;
        }
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int t = z.length() - 1;
            while (t >= 0 && z.charAt(t) == '0') {
                --t;
            }
            if (t >= 0 && z.charAt(t) == '.') {
                --t;
            }
            z = z.substring(0, t + 1);
        }
        return z;
    }

    private String exp_format(double d) {
        String f = "";
        int e = 0;
        double dd = d;
        double factor = 1.0;
        while (dd > 10.0) {
            ++e;
            factor /= 10.0;
            dd /= 10.0;
        }
        while (dd < 1.0) {
            --e;
            factor *= 10.0;
            dd *= 10.0;
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixed_format(d);
        }
        f = f + this.fixed_format(d *= factor);
        f = this.fmt == 'e' || this.fmt == 'g' ? f + "e" : f + "E";
        String p = "000";
        if (e >= 0) {
            f = f + "+";
            p = p + e;
        } else {
            f = f + "-";
            p = p + -e;
        }
        return f + p.substring(p.length() - 3, p.length());
    }
}

