/*
 * Decompiled with CFR 0.152.
 */
package chapman.io;

import chapman.io.Fmt;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileOut {
    private PrintWriter out;
    public final int WRITE_OK = 0;
    public final int IO_EXCEPTION = -999;
    public int writeStatus;

    public FileOut(String fileName) {
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, false)));
        }
        catch (IOException e) {
            System.out.println("IOException on file open: the stack trace is:");
            e.printStackTrace();
            this.writeStatus = -999;
        }
    }

    public FileOut(String fileName, boolean append) {
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(fileName, append)));
        }
        catch (IOException e) {
            System.out.println("IOException on file open: the stack trace is:");
            e.printStackTrace();
            this.writeStatus = -999;
        }
    }

    public void printf(String fmt, double x) {
        this.out.print(Fmt.sprintf(fmt, x));
        this.writeStatus = 0;
    }

    public void printf(String fmt, long l) {
        this.out.print(Fmt.sprintf(fmt, l));
        this.writeStatus = 0;
    }

    public void printf(String fmt, char c) {
        this.out.print(Fmt.sprintf(fmt, c));
        this.writeStatus = 0;
    }

    public void printf(String fmt, String s) {
        this.out.print(Fmt.sprintf(fmt, s));
        this.writeStatus = 0;
    }

    public void close() {
        this.out.close();
    }

    protected void finalize() {
        try {
            this.out.close();
            super.finalize();
        }
        catch (Throwable e) {
            System.out.println("Throwable: the stack trace is:");
            e.printStackTrace();
        }
    }
}

