/*
 * Decompiled with CFR 0.152.
 */
package chapman.graphics;

import chapman.graphics.InvalidPlotValueException;
import chapman.io.Fmt;
import chapman.math.Array;
import chapman.math.Complex;
import chapman.math.InvalidArraySizeException;
import chapman.math.Math1;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JPlot2D
extends JComponent
implements ActionListener,
Cloneable,
Printable {
    public static final int MAX_CURVES = 16;
    public static final int MAX_ANNOTATIONS = 16;
    public static final float[] LINESTYLE_SOLID = new float[]{6.0f, 0.0f};
    public static final float[] LINESTYLE_DOT = new float[]{3.0f, 6.0f};
    public static final float[] LINESTYLE_LONGDASH = new float[]{16.0f, 6.0f};
    public static final float[] LINESTYLE_SHORTDASH = new float[]{8.0f, 6.0f};
    private static final float[][] LINESTYLE = new float[][]{{6.0f, 0.0f}, {3.0f, 6.0f}, {16.0f, 6.0f}, {8.0f, 6.0f}};
    private static final Color[] LINE_COLOR = new Color[]{Color.blue, Color.red, Color.black, Color.orange, Color.green, Color.pink, Color.cyan};
    public static final boolean LINE_OFF = false;
    public static final boolean LINE_ON = true;
    private static final Color[] FILL_COLOR = new Color[]{Color.cyan, Color.green, Color.red, Color.yellow, Color.blue, Color.pink, Color.orange};
    public static final int MARKER_SQUARE = 1;
    public static final int MARKER_CIRCLE = 2;
    public static final int MARKER_TRIANGLE = 3;
    public static final int MARKER_DIAMOND = 4;
    public static final int MARKER_DOWNTRIANGLE = 5;
    private static final int[] MARKER_STYLE = new int[]{1, 2, 3, 4, 5};
    private static final Color[] MARKER_COLOR = new Color[]{Color.blue, Color.red, Color.black, Color.orange, Color.green, Color.pink, Color.cyan};
    public static final boolean MARKER_OFF = false;
    public static final boolean MARKER_ON = true;
    public static final boolean GRID_ON = true;
    public static final boolean GRID_OFF = false;
    public static final int LINEAR = 0;
    public static final int SEMILOGX = 1;
    public static final int SEMILOGY = 2;
    public static final int LOGLOG = 3;
    public static final int POLAR = 4;
    public static final int BAR = 5;
    private int plotType = 0;
    private boolean polarPlot = false;
    private boolean barPlot = false;
    private boolean barPlotH = false;
    private boolean logXAxis = false;
    private boolean logYAxis = false;
    private float[][] lineStyle = new float[16][];
    private float[] lineWidth = new float[16];
    private int[] markerStyle = new int[16];
    private int currentCurve = 0;
    private int totalCurves = 0;
    private Color backColor = Color.white;
    private Color gridColor = Color.gray;
    private Color labelColor = Color.black;
    private Color boxColor = Color.black;
    private Color ticColor = Color.black;
    private Color[] lineColor = new Color[16];
    private Color[] fillColor = new Color[16];
    private Color[] markerColor = new Color[16];
    private Color[] annotationColor = new Color[16];
    private String title = "Title";
    private String xLabel = "X label";
    private String yLabel = "Y label";
    private boolean changed = true;
    private String[] annotations = new String[16];
    private double[] xAnnPos = new double[16];
    private double[] yAnnPos = new double[16];
    private int currentAnnotation = 0;
    private int totalAnnotations = 0;
    private boolean validTitle = false;
    private boolean validXLabel = false;
    private boolean validYLabel = false;
    private BasicStroke bb;
    private BasicStroke bg;
    private BasicStroke bm;
    private BasicStroke[] bs = new BasicStroke[16];
    private BasicStroke bt;
    private JPopupMenu popup;
    private JMenuItem printCanvas;
    private JMenuItem printCanvasDialog;
    private BufferedImage offImg;
    private BufferedImage offImg1;
    private int maxCharHeight;
    private int maxStringLength;
    private int minFontSize = 8;
    private FontMetrics fontMetrics;
    private int fontSize;
    private int fontStyle;
    private String fontName;
    private int stringWidth;
    private int stringHeight;
    private Dimension size;
    private Dimension plotSize = new Dimension(0, 0);
    private int plotStartX;
    private int plotStartY;
    private int barStartX;
    private float xLeftMargin = 0.125f;
    private float xRightMargin = 0.045f;
    private float yTopMargin = 0.075f;
    private float yBottomMargin = 0.075f;
    private boolean autoXScale = true;
    private boolean autoYScale = true;
    private double xMax = 0.0;
    private double xMaxLog = 0.0;
    private double xMin = 0.0;
    private double xMinLog = 0.0;
    private double yMax = 0.0;
    private double yMaxLog = 0.0;
    private double yMin = 0.0;
    private double yMinLog = 0.0;
    private double xScale;
    private double yScale;
    private boolean autoXTicMode = true;
    private boolean autoYTicMode = true;
    private boolean[] plotLine = new boolean[16];
    private boolean[] plotMarker = new boolean[16];
    private boolean xGridLines = false;
    private boolean yGridLines = false;
    private boolean xTicMarks = true;
    private boolean yTicMarks = true;
    private double[] xTic;
    private double[] xTicLog;
    private String[] xTicS;
    private double[] yTic;
    private double[] yTicLog;
    private String[] yTicS;
    private double[][] xVal = new double[16][];
    private double[][] yVal = new double[16][];

    public JPlot2D() {
        this.xVal[0] = null;
        this.yVal[0] = null;
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 0;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        this.popup = new JPopupMenu("Options");
        this.printCanvas = new JMenuItem("Print");
        this.printCanvas.addActionListener(this);
        this.printCanvasDialog = new JMenuItem("Print with Dialog");
        this.printCanvasDialog.addActionListener(this);
        this.popup.add(this.printCanvas);
        this.popup.add(this.printCanvasDialog);
        this.add(this.popup);
        this.enableEvents(16L);
    }

    public JPlot2D(double[] y) {
        double[] x = new double[y.length];
        int i = 0;
        while (i < y.length) {
            x[i] = i;
            ++i;
        }
        this.xVal[0] = x;
        this.yVal[0] = y;
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 1;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        this.popup = new JPopupMenu("Options");
        this.printCanvas = new JMenuItem("Print");
        this.printCanvas.addActionListener(this);
        this.printCanvasDialog = new JMenuItem("Print with Dialog");
        this.printCanvasDialog.addActionListener(this);
        this.popup.add(this.printCanvas);
        this.popup.add(this.printCanvasDialog);
        this.add(this.popup);
        this.enableEvents(16L);
    }

    public JPlot2D(double[] y, int nvals) {
        if (y.length < nvals) {
            String s = "Insufficient y data: y.length = " + y.length + "; required = " + nvals;
            throw new InvalidArraySizeException(s);
        }
        double[] x1 = new double[nvals];
        double[] y1 = new double[nvals];
        int i = 0;
        while (i < nvals) {
            x1[i] = i;
            y1[i] = y[i];
            ++i;
        }
        this.xVal[0] = x1;
        this.yVal[0] = y1;
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 1;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        this.popup = new JPopupMenu("Options");
        this.printCanvas = new JMenuItem("Print");
        this.printCanvas.addActionListener(this);
        this.printCanvasDialog = new JMenuItem("Print with Dialog");
        this.printCanvasDialog.addActionListener(this);
        this.popup.add(this.printCanvas);
        this.popup.add(this.printCanvasDialog);
        this.add(this.popup);
        this.enableEvents(16L);
    }

    public JPlot2D(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new InvalidArraySizeException("x and y must be equal in length!");
        }
        this.xVal[0] = x;
        this.yVal[0] = y;
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 1;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        this.popup = new JPopupMenu("Options");
        this.printCanvas = new JMenuItem("Print");
        this.printCanvas.addActionListener(this);
        this.printCanvasDialog = new JMenuItem("Print with Dialog");
        this.printCanvasDialog.addActionListener(this);
        this.popup.add(this.printCanvas);
        this.popup.add(this.printCanvasDialog);
        this.add(this.popup);
        this.enableEvents(16L);
    }

    public JPlot2D(double[] x, double[] y, int nvals) {
        if (x.length < nvals) {
            String s = "Insufficient x data: x.length = " + x.length + "; required = " + nvals;
            throw new InvalidArraySizeException(s);
        }
        if (y.length < nvals) {
            String s = "Insufficient y data: y.length = " + y.length + "; required = " + nvals;
            throw new InvalidArraySizeException(s);
        }
        double[] x1 = new double[nvals];
        double[] y1 = new double[nvals];
        int i = 0;
        while (i < nvals) {
            x1[i] = x[i];
            y1[i] = y[i];
            ++i;
        }
        this.xVal[0] = x1;
        this.yVal[0] = y1;
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 1;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        this.popup = new JPopupMenu("Options");
        this.printCanvas = new JMenuItem("Print");
        this.printCanvas.addActionListener(this);
        this.printCanvasDialog = new JMenuItem("Print with Dialog");
        this.printCanvasDialog.addActionListener(this);
        this.popup.add(this.printCanvas);
        this.popup.add(this.printCanvasDialog);
        this.add(this.popup);
        this.enableEvents(16L);
    }

    public JPlot2D(Complex[] c) {
        double[] x = new double[c.length];
        double[] y = new double[c.length];
        int i = 0;
        while (i < c.length) {
            x[i] = c[i].re();
            y[i] = c[i].im();
            ++i;
        }
        this.xVal[0] = x;
        this.yVal[0] = y;
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 1;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        this.popup = new JPopupMenu("Options");
        this.printCanvas = new JMenuItem("Print");
        this.printCanvas.addActionListener(this);
        this.printCanvasDialog = new JMenuItem("Print with Dialog");
        this.printCanvasDialog.addActionListener(this);
        this.popup.add(this.printCanvas);
        this.popup.add(this.printCanvasDialog);
        this.add(this.popup);
        this.enableEvents(16L);
    }

    private Graphics2D createGraphics2D(Graphics g) {
        Graphics2D g2 = null;
        this.size = this.getSize();
        if (this.offImg == null || this.offImg.getWidth() != this.size.width || this.offImg.getHeight() != this.size.height) {
            this.offImg = (BufferedImage)this.createImage(this.size.width, this.size.height);
            this.changed = true;
        }
        if (this.changed) {
            if (this.offImg != null) {
                g2 = this.offImg.createGraphics();
                g2.setBackground(this.getBackground());
            }
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.clearRect(0, 0, this.size.width, this.size.height);
        }
        return g2;
    }

    public void paintComponent(Graphics g) {
        if (this.xVal[0] != null) {
            Graphics2D g2 = this.createGraphics2D(g);
            if (this.changed) {
                if (this.polarPlot) {
                    this.polar(g2);
                } else if (this.barPlot) {
                    this.bar(g2);
                } else if (this.logXAxis && this.logYAxis) {
                    this.loglog(g2);
                } else if (this.logXAxis && !this.logYAxis) {
                    this.semilogx(g2);
                } else if (!this.logXAxis && this.logYAxis) {
                    this.semilogy(g2);
                } else if (!this.logXAxis && !this.logYAxis) {
                    this.linlin(g2);
                }
                this.changed = false;
                g2.dispose();
            }
            if (this.offImg != null && this.isShowing()) {
                g.drawImage(this.offImg, 0, 0, this);
            }
        } else {
            this.size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.size.width, this.size.height);
        }
    }

    public int print(Graphics g, PageFormat pf, int pi) {
        if (pi >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(pf.getImageableX(), pf.getImageableY());
        this.paint(g2);
        return 0;
    }

    public void setPlotType(int type) {
        if (type < 0 || type > 5) {
            String s = "Invalid plot type: " + type;
            throw new IndexOutOfBoundsException(s);
        }
        if (type == 0) {
            this.plotType = type;
            this.logXAxis = false;
            this.logYAxis = false;
            this.polarPlot = false;
            this.barPlot = false;
            this.barPlotH = false;
            this.changed = true;
        } else if (type == 1) {
            this.plotType = type;
            this.logXAxis = true;
            this.logYAxis = false;
            this.polarPlot = false;
            this.barPlot = false;
            this.barPlotH = false;
            this.changed = true;
        } else if (type == 2) {
            this.plotType = type;
            this.logXAxis = false;
            this.logYAxis = true;
            this.polarPlot = false;
            this.barPlot = false;
            this.barPlotH = false;
            this.changed = true;
        } else if (type == 3) {
            this.plotType = type;
            this.logXAxis = true;
            this.logYAxis = true;
            this.polarPlot = false;
            this.barPlot = false;
            this.barPlotH = false;
            this.changed = true;
        } else if (type == 4) {
            this.plotType = type;
            this.logXAxis = false;
            this.logYAxis = false;
            this.polarPlot = true;
            this.barPlot = false;
            this.barPlotH = false;
            this.changed = true;
        } else if (type == 5) {
            this.plotType = type;
            this.logXAxis = false;
            this.logYAxis = false;
            this.polarPlot = false;
            this.barPlot = true;
            this.barPlotH = false;
            this.changed = true;
            int i = 0;
            while (i < this.totalCurves) {
                this.lineStyle[i] = LINESTYLE_SOLID;
                ++i;
            }
        }
    }

    public int getPlotType() {
        return this.plotType;
    }

    public void setValues(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new InvalidArraySizeException("x and y must be equal in length!");
        }
        this.totalCurves = Math.max(this.totalCurves, 1);
        this.xVal[this.currentCurve] = x;
        this.yVal[this.currentCurve] = y;
        this.changed = true;
    }

    public void setValues(double[] x, double[] y, int curve) {
        if (x.length != y.length) {
            throw new InvalidArraySizeException("x and y must be equal in length!");
        }
        this.totalCurves = Math.max(this.totalCurves, 1);
        this.xVal[curve] = x;
        this.yVal[curve] = y;
        this.changed = true;
    }

    public void setValues(Complex[] c) {
        double[] x = new double[c.length];
        double[] y = new double[c.length];
        int i = 0;
        while (i < c.length) {
            x[i] = c[i].re();
            y[i] = c[i].im();
            ++i;
        }
        this.totalCurves = Math.max(this.totalCurves, 1);
        this.xVal[this.currentCurve] = x;
        this.yVal[this.currentCurve] = y;
        this.changed = true;
        this.repaint();
    }

    public void setValues(Complex[] c, int curve) {
        double[] x = new double[c.length];
        double[] y = new double[c.length];
        int i = 0;
        while (i < c.length) {
            x[i] = c[i].re();
            y[i] = c[i].im();
            ++i;
        }
        this.totalCurves = Math.max(this.totalCurves, 1);
        this.xVal[curve] = x;
        this.yVal[curve] = y;
        this.changed = true;
    }

    public void addCurve(double[] y) {
        if (this.totalCurves >= 16) {
            throw new InvalidPlotValueException("Too many curves (> 16)");
        }
        double[] x = new double[y.length];
        int i = 0;
        while (i < y.length) {
            x[i] = i;
            ++i;
        }
        this.currentCurve = ++this.totalCurves - 1;
        this.xVal[this.currentCurve] = x;
        this.yVal[this.currentCurve] = y;
        this.lineStyle[this.currentCurve] = LINESTYLE[this.currentCurve % 4];
        this.lineColor[this.currentCurve] = LINE_COLOR[this.currentCurve % 7];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.markerColor[this.currentCurve] = MARKER_COLOR[this.currentCurve % 7];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[this.currentCurve % 5];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        if (this.plotType == 5) {
            this.lineStyle[this.currentCurve] = LINESTYLE_SOLID;
        }
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
    }

    public void addCurve(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new InvalidArraySizeException("x and y must be equal in length!");
        }
        if (this.totalCurves >= 16) {
            throw new InvalidPlotValueException("Too many curves (> 16)");
        }
        this.currentCurve = ++this.totalCurves - 1;
        this.xVal[this.currentCurve] = x;
        this.yVal[this.currentCurve] = y;
        this.lineStyle[this.currentCurve] = LINESTYLE[this.currentCurve % 4];
        this.lineColor[this.currentCurve] = LINE_COLOR[this.currentCurve % 7];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.markerColor[this.currentCurve] = MARKER_COLOR[this.currentCurve % 7];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[this.currentCurve % 5];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        if (this.plotType == 5) {
            this.lineStyle[this.currentCurve] = LINESTYLE_SOLID;
        }
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
    }

    public void addCurve(Complex[] c) {
        if (this.totalCurves >= 16) {
            throw new InvalidPlotValueException("Too many curves (> 16)");
        }
        double[] x = new double[c.length];
        double[] y = new double[c.length];
        int i = 0;
        while (i < c.length) {
            x[i] = c[i].re();
            y[i] = c[i].im();
            ++i;
        }
        this.currentCurve = ++this.totalCurves - 1;
        this.xVal[this.currentCurve] = x;
        this.yVal[this.currentCurve] = y;
        this.lineStyle[this.currentCurve] = LINESTYLE[this.currentCurve % 4];
        this.lineColor[this.currentCurve] = LINE_COLOR[this.currentCurve % 7];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.markerColor[this.currentCurve] = MARKER_COLOR[this.currentCurve % 7];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[this.currentCurve % 5];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        if (this.plotType == 5) {
            this.lineStyle[this.currentCurve] = LINESTYLE_SOLID;
        }
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
    }

    public double[] getPlotX() {
        return this.xVal[this.currentCurve];
    }

    public double[] getPlotY() {
        return this.yVal[this.currentCurve];
    }

    public void setCurrentCurve(int c) {
        if (c < 0 || c > this.totalCurves - 1) {
            String s = "Invalid current curve: " + c;
            throw new IndexOutOfBoundsException(s);
        }
        this.currentCurve = c;
    }

    public void setLineState(boolean b) {
        this.plotLine[this.currentCurve] = b;
        this.changed = true;
    }

    public void setMarkerState(boolean b) {
        this.plotMarker[this.currentCurve] = b;
        this.changed = true;
    }

    public int getCurrentCurve() {
        return this.currentCurve;
    }

    public int getTotalCurves() {
        return this.totalCurves;
    }

    public void setCurrentAnnotation(int a) {
        if (a < 0 || a > this.totalCurves - 1) {
            String s = "Invalid current annotation: " + a;
            throw new IndexOutOfBoundsException(s);
        }
        this.currentAnnotation = a;
    }

    public int getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    public int getTotalAnnotations() {
        return this.totalAnnotations;
    }

    public void setBackgroundColor(Color c) {
        this.backColor = c;
        this.setBackground(this.backColor);
        this.changed = true;
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setLineStyle(float[] ls) {
        this.lineStyle[this.currentCurve] = ls;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
    }

    public float[] getLineStyle() {
        return this.lineStyle[this.currentCurve];
    }

    public void setLineColor(Color c) {
        this.lineColor[this.currentCurve] = c;
        this.changed = true;
    }

    public Color getLineColor() {
        return this.lineColor[this.currentCurve];
    }

    public void setMarkerStyle(int ms) {
        this.markerStyle[this.currentCurve] = ms;
        this.changed = true;
    }

    public int getMarkerStyle() {
        return this.markerStyle[this.currentCurve];
    }

    public void setMarkerColor(Color c) {
        this.markerColor[this.currentCurve] = c;
        this.changed = true;
    }

    public Color getMarkerColor() {
        return this.markerColor[this.currentCurve];
    }

    public void setFillColor(Color c) {
        this.fillColor[this.currentCurve] = c;
        this.changed = true;
    }

    public Color getFillColor() {
        return this.fillColor[this.currentCurve];
    }

    public void setLineWidth(float w) {
        this.lineWidth[this.currentCurve] = w;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
    }

    public float getLineWidth() {
        return this.lineWidth[this.currentCurve];
    }

    public void setTitle(String s) {
        this.title = s;
        this.validTitle = true;
        this.changed = true;
    }

    public String getTitle() {
        return this.title;
    }

    public void setXLabel(String s) {
        this.xLabel = s;
        this.validXLabel = true;
        this.changed = true;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setYLabel(String s) {
        this.yLabel = s;
        this.validYLabel = true;
        this.changed = true;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void addAnnotation(String s, double x, double y) {
        if (this.totalAnnotations >= 16) {
            throw new InvalidPlotValueException("Too many annotations (> 16)");
        }
        this.currentAnnotation = ++this.totalAnnotations - 1;
        this.annotations[this.currentAnnotation] = s;
        this.xAnnPos[this.currentAnnotation] = x;
        this.yAnnPos[this.currentAnnotation] = y;
        this.annotationColor[this.currentAnnotation] = Color.black;
    }

    public String getAnnotation() {
        return this.annotations[this.currentAnnotation];
    }

    public void setAnnotationColor(Color c) {
        this.annotationColor[this.currentAnnotation] = c;
        this.changed = true;
    }

    public Color getAnnotationColor() {
        return this.annotationColor[this.currentAnnotation];
    }

    public void setXScale(double[] x) {
        if (x.length != 2) {
            throw new InvalidPlotValueException("Array must have two values.");
        }
        if (x[0] >= x[1]) {
            throw new InvalidPlotValueException("xMax must be > xMin.");
        }
        this.autoXScale = false;
        this.xMin = x[0];
        this.xMax = x[1];
        this.changed = true;
    }

    public void setYScale(double[] y) {
        if (y.length != 2) {
            throw new InvalidPlotValueException("Input array must have two values.");
        }
        if (y[0] >= y[1]) {
            throw new InvalidPlotValueException("yMax must be > yMin.");
        }
        this.autoYScale = false;
        this.yMin = y[0];
        this.yMax = y[1];
        this.changed = true;
    }

    public double[] getXScale() {
        double[] xScale = new double[2];
        if (this.xMin == 0.0 && this.xMax == 0.0 && this.autoXScale) {
            this.xMax = Array.maxVal((double[])this.xVal[0]);
            this.xMin = Array.minVal((double[])this.xVal[0]);
            int i = 1;
            while (i < this.totalCurves) {
                this.xMax = Math.max(this.xMax, Array.maxVal((double[])this.xVal[i]));
                this.xMin = Math.min(this.xMin, Array.minVal((double[])this.xVal[i]));
                ++i;
            }
            if (this.logXAxis) {
                this.xMax = Math.pow(10.0, Math.ceil(Math1.log10((double)this.xMax)));
                this.xMin = Math.pow(10.0, Math.floor(Math1.log10((double)this.xMin)));
                if (this.xMin == this.xMax) {
                    this.xMax = 1.01 * this.xMin;
                }
                this.xMaxLog = Math1.log10((double)this.xMax);
                this.xMinLog = Math1.log10((double)this.xMin);
            }
        }
        xScale[0] = this.xMin;
        xScale[1] = this.xMax;
        return xScale;
    }

    public double[] getYScale() {
        double[] yScale = new double[2];
        if (this.yMin == 0.0 && this.yMax == 0.0 && this.autoYScale) {
            this.yMax = Array.maxVal((double[])this.yVal[0]);
            this.yMin = Array.minVal((double[])this.yVal[0]);
            int i = 1;
            while (i < this.totalCurves) {
                this.yMax = Math.max(this.yMax, Array.maxVal((double[])this.yVal[i]));
                this.yMin = Math.min(this.yMin, Array.minVal((double[])this.yVal[i]));
                ++i;
            }
            if (this.logYAxis) {
                this.yMax = Math.pow(10.0, Math.ceil(Math1.log10((double)this.yMax)));
                this.yMin = Math.pow(10.0, Math.floor(Math1.log10((double)this.yMin)));
                if (this.yMin == this.yMax) {
                    this.yMax = 1.01 * this.yMin;
                }
                this.yMaxLog = Math1.log10((double)this.yMax);
                this.yMinLog = Math1.log10((double)this.yMin);
            }
        }
        yScale[0] = this.yMin;
        yScale[1] = this.yMax;
        return yScale;
    }

    public void setAutoXScale() {
        this.autoXScale = true;
        this.changed = true;
    }

    public void setAutoYScale() {
        this.autoYScale = true;
        this.changed = true;
    }

    public void setGridState(boolean b) {
        this.xGridLines = b;
        this.yGridLines = b;
        this.changed = true;
    }

    public boolean getGridState() {
        return this.xGridLines;
    }

    public void setXTics(double[] xtic) {
        this.autoXTicMode = false;
        this.xTic = xtic;
        this.changed = true;
    }

    public double[] getXTics() {
        return this.xTic;
    }

    public void setYTics(double[] ytic) {
        this.autoYTicMode = false;
        this.yTic = ytic;
        this.changed = true;
    }

    public double[] getYTics() {
        return this.yTic;
    }

    public void setAutoXTics() {
        this.autoXTicMode = true;
        this.changed = true;
    }

    public void setAutoYTics() {
        this.autoYTicMode = true;
        this.changed = true;
    }

    public void removeAll() {
        int i = 0;
        while (i < this.xVal.length) {
            this.xVal[i] = null;
            this.yVal[i] = null;
            ++i;
        }
        this.setBackground(this.backColor);
        this.currentCurve = 0;
        this.totalCurves = 0;
        this.lineStyle[this.currentCurve] = LINESTYLE[0];
        this.lineColor[this.currentCurve] = LINE_COLOR[0];
        this.lineWidth[this.currentCurve] = 1.0f;
        this.fillColor[this.currentCurve] = FILL_COLOR[0];
        this.markerColor[this.currentCurve] = MARKER_COLOR[0];
        this.markerStyle[this.currentCurve] = MARKER_STYLE[0];
        this.plotLine[this.currentCurve] = true;
        this.plotMarker[this.currentCurve] = false;
        this.changed = true;
        this.bs[this.currentCurve] = new BasicStroke(this.lineWidth[this.currentCurve], 2, 0, 6.0f, this.lineStyle[this.currentCurve], 0.0f);
        float[] boxStyle = new float[]{12.0f, 0.0f};
        this.bb = new BasicStroke(1.0f, 2, 0, 6.0f, boxStyle, 0.0f);
        float[] gridStyle = new float[]{3.0f, 6.0f};
        this.bg = new BasicStroke(1.0f, 2, 0, 1.0f, gridStyle, 0.0f);
        float[] ticStyle = new float[]{12.0f, 0.0f};
        this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
    }

    private FontMetrics pickFont(Graphics g, String longString, int xSpace) {
        boolean fontFits = false;
        Font font = g.getFont();
        FontMetrics fontMetrics = g.getFontMetrics();
        int size = font.getSize();
        String name = font.getName();
        int style = font.getStyle();
        while (!fontFits) {
            if (fontMetrics.getHeight() <= this.maxCharHeight && fontMetrics.stringWidth(longString) <= xSpace) {
                fontFits = true;
                continue;
            }
            if (size <= this.minFontSize) {
                fontFits = true;
                continue;
            }
            font = new Font(name, style, --size);
            g.setFont(font);
            fontMetrics = g.getFontMetrics();
        }
        return fontMetrics;
    }

    private static String calcNumberString(double x) {
        double xabs = Math.abs(x);
        if (xabs > 1000000.0) {
            return Fmt.sprintf("%.2e", x);
        }
        if (xabs > 9999.5) {
            return Fmt.sprintf("%d", Math.rint(x));
        }
        if (xabs > 999.5) {
            return Fmt.sprintf("%.4g", x);
        }
        if (xabs > 99.95) {
            return Fmt.sprintf("%.3g", x);
        }
        if (xabs > 9.995) {
            return Fmt.sprintf("%.2g", x);
        }
        if (xabs > 0.0995) {
            return Fmt.sprintf("%.3g", x);
        }
        if (xabs > 0.00995) {
            return Fmt.sprintf("%.4g", x);
        }
        if (xabs == 0.0) {
            return "0";
        }
        return Fmt.sprintf("%.2e", x);
    }

    private void calcXTics(double xmin, double xmax) {
        double[] bestDelta = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
        if (xmin == xmax) {
            this.xMin = xmin;
            this.xMax = xmax + 1.0;
            int tics = 2;
            this.xTic = new double[2];
            this.xTicS = new String[2];
            this.xTic[0] = this.xMin;
            this.xTic[1] = this.xMax;
            this.xTicS[0] = JPlot2D.calcNumberString(this.xTic[0]);
            this.xTicS[1] = JPlot2D.calcNumberString(this.xTic[1]);
            return;
        }
        double xDelta = xmax - xmin;
        double power = Math.pow(10.0, Math.round(Math1.log10((double)xDelta) - 1.0));
        int i = 0;
        while (i < bestDelta.length) {
            double low;
            double delta = power * bestDelta[i];
            double high = delta * Math.ceil(xmax / delta);
            int tics = (int)Math.round((high - (low = delta * Math.floor(xmin / delta))) / delta) + 1;
            if (tics <= 11) {
                this.xMin = low;
                this.xMax = high;
                delta = (high - low) / (double)(tics - 1);
                this.xTic = new double[tics];
                this.xTicS = new String[tics];
                int j = 0;
                while (j < this.xTic.length) {
                    this.xTic[j] = low + delta * (double)j;
                    this.xTicS[j] = JPlot2D.calcNumberString(this.xTic[j]);
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    private void calcYTics(double ymin, double ymax) {
        double[] bestDelta = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
        if (ymin == ymax) {
            this.yMin = ymin;
            this.yMax = ymax + 1.0;
            int tics = 2;
            this.yTic = new double[2];
            this.yTicS = new String[2];
            this.yTic[0] = this.yMin;
            this.yTic[1] = this.yMax;
            this.yTicS[0] = JPlot2D.calcNumberString(this.yTic[0]);
            this.yTicS[1] = JPlot2D.calcNumberString(this.yTic[1]);
            return;
        }
        double yDelta = ymax - ymin;
        double power = Math.pow(10.0, Math.round(Math1.log10((double)yDelta) - 1.0));
        int i = 0;
        while (i < bestDelta.length) {
            double low;
            double delta = power * bestDelta[i];
            double high = delta * Math.ceil(ymax / delta);
            int tics = (int)Math.round((high - (low = delta * Math.floor(ymin / delta))) / delta) + 1;
            if (tics <= 11) {
                this.yMin = low;
                this.yMax = high;
                delta = (high - low) / (double)(tics - 1);
                this.yTic = new double[tics];
                this.yTicS = new String[tics];
                int j = 0;
                while (j < this.yTic.length) {
                    this.yTic[j] = low + delta * (double)j;
                    this.yTicS[j] = JPlot2D.calcNumberString(this.yTic[j]);
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    private void calcPolarCircles(double ymax) {
        double[] bestDelta = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
        double ymin = 0.0;
        if (ymin == ymax) {
            this.yMin = ymin;
            this.yMax = ymax + 1.0;
            int tics = 2;
            this.yTic = new double[2];
            this.yTicS = new String[2];
            this.yTic[0] = this.yMin;
            this.yTic[1] = this.yMax;
            this.yTicS[0] = JPlot2D.calcNumberString(this.yTic[0]);
            this.yTicS[1] = JPlot2D.calcNumberString(this.yTic[1]);
            return;
        }
        double yDelta = ymax - ymin;
        double power = Math.pow(10.0, Math.round(Math1.log10((double)yDelta) - 1.0));
        int i = 0;
        while (i < bestDelta.length) {
            double low;
            double delta = power * bestDelta[i];
            double high = delta * Math.ceil(ymax / delta);
            int tics = (int)Math.round((high - (low = delta * Math.floor(ymin / delta))) / delta) + 1;
            if (tics <= 11) {
                if (tics == 11) {
                    tics = 6;
                } else if (tics == 9) {
                    tics = 5;
                } else if (tics == 7) {
                    tics = 4;
                } else if (tics == 5) {
                    tics = 3;
                }
                this.yMin = low;
                this.yMax = high;
                delta = (high - low) / (double)(tics - 1);
                this.yTic = new double[tics];
                this.yTicS = new String[tics];
                int j = 0;
                while (j < this.yTic.length) {
                    this.yTic[j] = low + delta * (double)j;
                    this.yTicS[j] = JPlot2D.calcNumberString(this.yTic[j]);
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    private void calcXLogTics(double low, double high) {
        double[] decade = new double[]{0.0, 0.30102999566398, 0.47712125471966, 0.60205999132796, 0.69897000433602, 0.77815125038364, 0.84509804001426, 0.90308998699194, 0.95424250943932, 1.0};
        this.xMin = Math.pow(10.0, Math.floor(Math1.log10((double)low)));
        this.xMax = Math.pow(10.0, Math.ceil(Math1.log10((double)high)));
        double loglow = Math1.log10((double)this.xMin);
        double loghigh = Math1.log10((double)this.xMax);
        double diff = loghigh - loglow;
        this.xTicLog = new double[(int)Math.round(10.0 * diff)];
        this.xTic = new double[this.xTicLog.length];
        this.xTicS = new String[this.xTicLog.length];
        int k = 0;
        int i = 0;
        while ((double)i < diff) {
            int j = 0;
            while (j < 10) {
                this.xTicLog[k] = loglow + (double)i + decade[j];
                this.xTic[k] = Math.pow(10.0, this.xTicLog[k]);
                this.xTicS[k] = Math.abs(decade[j]) < 0.001 || Math.abs(decade[j] - 1.0) < 0.001 ? JPlot2D.calcNumberString(this.xTic[k]) : " ";
                ++k;
                ++j;
            }
            ++i;
        }
    }

    private void calcYLogTics(double low, double high) {
        double[] decade = new double[]{0.0, 0.30102999566398, 0.47712125471966, 0.60205999132796, 0.69897000433602, 0.77815125038364, 0.84509804001426, 0.90308998699194, 0.95424250943932, 1.0};
        this.yMin = Math.pow(10.0, Math.floor(Math1.log10((double)low)));
        this.yMax = Math.pow(10.0, Math.ceil(Math1.log10((double)high)));
        double loglow = Math1.log10((double)this.yMin);
        double loghigh = Math1.log10((double)this.yMax);
        double diff = loghigh - loglow;
        this.yTicLog = new double[(int)Math.round(10.0 * diff)];
        this.yTic = new double[this.yTicLog.length];
        this.yTicS = new String[this.yTicLog.length];
        int k = 0;
        int i = 0;
        while ((double)i < diff) {
            int j = 0;
            while (j < 10) {
                this.yTicLog[k] = loglow + (double)i + decade[j];
                this.yTic[k] = Math.pow(10.0, this.yTicLog[k]);
                this.yTicS[k] = Math.abs(decade[j]) < 0.001 || Math.abs(decade[j] - 1.0) < 0.001 ? JPlot2D.calcNumberString(this.yTic[k]) : " ";
                ++k;
                ++j;
            }
            ++i;
        }
    }

    private void linlin(Graphics2D g2) {
        AffineTransform at;
        double y1;
        double x1;
        int i;
        this.size = this.getSize();
        this.plotSize.width = Math.round((float)this.size.width * (1.0f - this.xLeftMargin - this.xRightMargin));
        this.plotSize.height = Math.round((float)this.size.height * (1.0f - this.yTopMargin - this.yBottomMargin));
        this.plotStartX = Math.round((float)this.size.width * this.xLeftMargin);
        this.plotStartY = Math.round((float)this.size.height * this.yTopMargin);
        if (this.autoXScale) {
            this.xMax = Array.maxVal((double[])this.xVal[0]);
            this.xMin = Array.minVal((double[])this.xVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.xMax = Math.max(this.xMax, Array.maxVal((double[])this.xVal[i]));
                this.xMin = Math.min(this.xMin, Array.minVal((double[])this.xVal[i]));
                ++i;
            }
        }
        if (this.autoYScale) {
            this.yMax = Array.maxVal((double[])this.yVal[0]);
            this.yMin = Array.minVal((double[])this.yVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.yMax = Math.max(this.yMax, Array.maxVal((double[])this.yVal[i]));
                this.yMin = Math.min(this.yMin, Array.minVal((double[])this.yVal[i]));
                ++i;
            }
        }
        if (this.autoXTicMode) {
            this.calcXTics(this.xMin, this.xMax);
        }
        if (this.autoYTicMode) {
            this.calcYTics(this.yMin, this.yMax);
        }
        this.xScale = Math.abs(this.xMax - this.xMin) > 0.0 ? (double)this.plotSize.width / (this.xMax - this.xMin) : 1.0;
        this.yScale = Math.abs(this.yMax - this.yMin) > 0.0 ? (double)this.plotSize.height / (this.yMax - this.yMin) : 1.0;
        g2.setStroke(this.bb);
        g2.setColor(this.boxColor);
        Line2D.Double line = new Line2D.Double(this.plotStartX, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY);
        g2.draw(line);
        g2.setStroke(this.bg);
        g2.setColor(this.gridColor);
        if (this.xGridLines) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yGridLines) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, this.plotStartX + this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        g2.setStroke(this.bt);
        g2.setColor(this.ticColor);
        if (this.xTicMarks) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.025 * (double)this.plotSize.height);
                g2.draw(line);
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.975 * (double)this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yTicMarks) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.025 * (double)this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                line = new Line2D.Double(this.plotStartX + this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.975 * (double)this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)((double)this.plotSize.width / (1.2 * (double)this.xTic.length));
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        Font font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.xTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.xTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xTicS[i], (int)((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX - (double)(this.stringWidth / 2)), this.plotStartY + this.plotSize.height + 11);
            ++i;
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)(0.5 * (double)this.plotStartX);
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.yTicS.length) {
            int fudge = i == 0 ? 5 : 12;
            this.stringWidth = this.fontMetrics.stringWidth(this.yTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.yTicS[i], this.plotStartX - this.stringWidth - 6, (int)(-(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY - (double)(this.stringHeight / 2) + (double)fudge));
            ++i;
        }
        i = 0;
        while (i < this.totalCurves) {
            int j;
            if (this.plotLine[i]) {
                g2.setStroke(this.bs[i]);
                g2.setColor(this.lineColor[i]);
                j = 0;
                while (j < this.xVal[i].length - 1) {
                    x1 = this.xVal[i][j] - this.xMin;
                    double x2 = this.xVal[i][j + 1] - this.xMin;
                    y1 = this.yVal[i][j] - this.yMax;
                    double y2 = this.yVal[i][j + 1] - this.yMax;
                    line = new Line2D.Double(x1 * this.xScale + (double)this.plotStartX, -y1 * this.yScale + (double)this.plotStartY, x2 * this.xScale + (double)this.plotStartX, -y2 * this.yScale + (double)this.plotStartY);
                    g2.draw(line);
                    ++j;
                }
            }
            if (this.plotMarker[i]) {
                if (this.bm == null) {
                    this.bm = new BasicStroke(2.0f, 2, 0, 6.0f, LINESTYLE_SOLID, 0.0f);
                }
                g2.setStroke(this.bm);
                g2.setColor(this.markerColor[i]);
                j = 0;
                while (j < this.xVal[i].length) {
                    float ys;
                    float xs;
                    GeneralPath p;
                    if (this.markerStyle[i] == 1) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = this.yVal[i][j] - this.yMax;
                        Rectangle2D.Double rect = new Rectangle2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(rect);
                    }
                    if (this.markerStyle[i] == 2) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = this.yVal[i][j] - this.yMax;
                        Ellipse2D.Double ell = new Ellipse2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(ell);
                    }
                    if (this.markerStyle[i] == 3) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = this.yVal[i][j] - this.yMax;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 2.0);
                        p.moveTo(xs, ys);
                        p.lineTo(xs + 6.0f, ys);
                        p.lineTo(xs + 3.0f, ys - 5.2f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 4) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = this.yVal[i][j] - this.yMax;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY);
                        p.moveTo(xs - 4.0f, ys);
                        p.lineTo(xs, ys + 4.0f);
                        p.lineTo(xs + 4.0f, ys);
                        p.lineTo(xs, ys - 4.0f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 5) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = this.yVal[i][j] - this.yMax;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 3.0);
                        p.moveTo(xs, ys - 5.2f);
                        p.lineTo(xs + 6.0f, ys - 5.2f);
                        p.lineTo(xs + 3.0f, ys);
                        p.closePath();
                        g2.draw(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.maxCharHeight = this.plotStartY - 15;
        this.maxStringLength = 3 * this.plotSize.width / 4;
        this.minFontSize = 12;
        g2.setColor(this.labelColor);
        if (this.validTitle) {
            font = new Font("Helvetica", 1, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.title, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.title);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.title, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, this.plotStartY / 2 + this.stringHeight / 2);
        }
        if (this.validXLabel) {
            this.maxStringLength = this.plotSize.width;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.xLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.xLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xLabel, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, 3 * this.plotStartY / 2 + this.plotSize.height + this.stringHeight / 2);
        }
        if (this.validYLabel) {
            this.maxStringLength = this.plotSize.height;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.yLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.yLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            g2.setTransform(at);
            int xPos = this.plotStartY / 2 + this.plotSize.height / 2 + this.stringWidth / 2;
            int yPos = (int)(1.05 * (double)this.stringHeight);
            g2.drawString(this.yLabel, -xPos, yPos);
        }
        at = new AffineTransform();
        g2.setTransform(at);
        i = 0;
        while (i < this.totalAnnotations) {
            x1 = this.xAnnPos[i] - this.xMin;
            y1 = this.yAnnPos[i] - this.yMax;
            this.maxCharHeight = 26;
            this.maxStringLength = this.logXAxis ? (int)Math.floor((this.xMaxLog - Math1.log10((double)this.xAnnPos[i])) * (double)this.plotSize.width) : (int)Math.floor((this.xMax - this.xAnnPos[i]) * (double)this.plotSize.width);
            this.minFontSize = 8;
            g2.setColor(this.annotationColor[i]);
            font = new Font("Helvetica", 0, 12);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.annotations[i], this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.annotations[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.annotations[i], (int)(x1 * this.xScale + (double)this.plotStartX), (int)(-y1 * this.yScale + (double)this.plotStartY));
            ++i;
        }
    }

    private void loglog(Graphics2D g2) {
        AffineTransform at;
        double y1;
        double x1;
        int i;
        this.size = this.getSize();
        this.plotSize.width = Math.round((float)this.size.width * (1.0f - this.xLeftMargin - this.xRightMargin));
        this.plotSize.height = Math.round((float)this.size.height * (1.0f - this.yTopMargin - this.yBottomMargin));
        this.plotStartX = Math.round((float)this.size.width * this.xLeftMargin);
        this.plotStartY = Math.round((float)this.size.height * this.yTopMargin);
        if (this.autoXScale) {
            this.xMax = Array.maxVal((double[])this.xVal[0]);
            this.xMin = Array.minVal((double[])this.xVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.xMax = Math.max(this.xMax, Array.maxVal((double[])this.xVal[i]));
                this.xMin = Math.min(this.xMin, Array.minVal((double[])this.xVal[i]));
                ++i;
            }
            if (this.xMin <= 0.0) {
                String s = "Min x plot value <= 0 in logarithmic plot: " + this.xMin;
                throw new InvalidPlotValueException(s);
            }
            this.xMax = Math.pow(10.0, Math.ceil(Math1.log10((double)this.xMax)));
            this.xMin = Math.pow(10.0, Math.floor(Math1.log10((double)this.xMin)));
            if (this.xMin == this.xMax) {
                this.xMax = 1.01 * this.xMin;
            }
            this.xMaxLog = Math1.log10((double)this.xMax);
            this.xMinLog = Math1.log10((double)this.xMin);
        } else {
            if (this.xMin <= 0.0) {
                String s = "Min x plot value <= 0 in logarithmic plot: " + this.xMin;
                throw new InvalidPlotValueException(s);
            }
            if (this.xMin == this.xMax) {
                this.xMax = 1.01 * this.xMin;
            }
            this.xMaxLog = Math1.log10((double)this.xMax);
            this.xMinLog = Math1.log10((double)this.xMin);
        }
        if (this.autoYScale) {
            this.yMax = Array.maxVal((double[])this.yVal[0]);
            this.yMin = Array.minVal((double[])this.yVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.yMax = Math.max(this.yMax, Array.maxVal((double[])this.yVal[i]));
                this.yMin = Math.min(this.yMin, Array.minVal((double[])this.yVal[i]));
                ++i;
            }
            if (this.yMin <= 0.0) {
                String s = "Min y plot value <= 0 in logarithmic plot: " + this.yMin;
                throw new InvalidPlotValueException(s);
            }
            this.yMax = Math.pow(10.0, Math.ceil(Math1.log10((double)this.yMax)));
            this.yMin = Math.pow(10.0, Math.floor(Math1.log10((double)this.yMin)));
            if (this.yMin == this.yMax) {
                this.yMax = 1.01 * this.yMin;
            }
            this.yMaxLog = Math1.log10((double)this.yMax);
            this.yMinLog = Math1.log10((double)this.yMin);
        } else {
            if (this.yMin <= 0.0) {
                String s = "Min y plot value <= 0 in logarithmic plot: " + this.yMin;
                throw new InvalidPlotValueException(s);
            }
            if (this.yMin == this.yMax) {
                this.yMax = 1.01 * this.yMin;
            }
            this.yMaxLog = Math1.log10((double)this.yMax);
            this.yMinLog = Math1.log10((double)this.yMin);
        }
        if (this.autoXTicMode) {
            this.calcXLogTics(this.xMin, this.xMax);
        }
        if (this.autoYTicMode) {
            this.calcYLogTics(this.yMin, this.yMax);
        }
        this.xScale = Math.abs(this.xMaxLog - this.xMinLog) > 0.0 ? (double)this.plotSize.width / (this.xMaxLog - this.xMinLog) : 1.0;
        this.yScale = Math.abs(this.yMaxLog - this.yMinLog) > 0.0 ? (double)this.plotSize.height / (this.yMaxLog - this.yMinLog) : 1.0;
        g2.setStroke(this.bb);
        g2.setColor(this.boxColor);
        Line2D.Double line = new Line2D.Double(this.plotStartX, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY);
        g2.draw(line);
        g2.setStroke(this.bg);
        g2.setColor(this.gridColor);
        if (this.xGridLines) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yGridLines) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY, this.plotStartX + this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        g2.setStroke(this.bt);
        g2.setColor(this.ticColor);
        if (this.xTicMarks) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.025 * (double)this.plotSize.height);
                g2.draw(line);
                line = new Line2D.Double((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height, (this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.975 * (double)this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yTicMarks) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.025 * (double)this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                line = new Line2D.Double(this.plotStartX + this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.975 * (double)this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = this.logXAxis ? (int)(this.xRightMargin * (float)this.plotSize.width) : (int)((double)this.plotSize.width / (1.2 * (double)this.xTic.length));
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        Font font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.xTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.xTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xTicS[i], (int)((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX - (double)(this.stringWidth / 2)), this.plotStartY + this.plotSize.height + 11);
            ++i;
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)(0.5 * (double)this.plotStartX);
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.yTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.yTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            int fudge = i == 0 ? 5 : 12;
            g2.drawString(this.yTicS[i], this.plotStartX - this.stringWidth - 6, (int)(-(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY - (double)(this.stringHeight / 2) + (double)fudge));
            ++i;
        }
        i = 0;
        while (i < this.totalCurves) {
            int j;
            if (this.plotLine[i]) {
                g2.setStroke(this.bs[i]);
                g2.setColor(this.lineColor[i]);
                j = 0;
                while (j < this.xVal[i].length - 1) {
                    x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                    double x2 = Math1.log10((double)this.xVal[i][j + 1]) - this.xMinLog;
                    y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                    double y2 = Math1.log10((double)this.yVal[i][j + 1]) - this.yMaxLog;
                    line = new Line2D.Double(x1 * this.xScale + (double)this.plotStartX, -y1 * this.yScale + (double)this.plotStartY, x2 * this.xScale + (double)this.plotStartX, -y2 * this.yScale + (double)this.plotStartY);
                    g2.draw(line);
                    ++j;
                }
            }
            if (this.plotMarker[i]) {
                if (this.bm == null) {
                    this.bm = new BasicStroke(2.0f, 2, 0, 6.0f, LINESTYLE_SOLID, 0.0f);
                }
                g2.setStroke(this.bm);
                g2.setColor(this.markerColor[i]);
                j = 0;
                while (j < this.xVal[i].length) {
                    float ys;
                    float xs;
                    GeneralPath p;
                    if (this.markerStyle[i] == 1) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        Rectangle2D.Double rect = new Rectangle2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(rect);
                    }
                    if (this.markerStyle[i] == 2) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        Ellipse2D.Double ell = new Ellipse2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(ell);
                    }
                    if (this.markerStyle[i] == 3) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 2.0);
                        p.moveTo(xs, ys);
                        p.lineTo(xs + 6.0f, ys);
                        p.lineTo(xs + 3.0f, ys - 5.2f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 4) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY);
                        p.moveTo(xs - 4.0f, ys);
                        p.lineTo(xs, ys + 4.0f);
                        p.lineTo(xs + 4.0f, ys);
                        p.lineTo(xs, ys - 4.0f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 5) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 3.0);
                        p.moveTo(xs, ys - 5.2f);
                        p.lineTo(xs + 6.0f, ys - 5.2f);
                        p.lineTo(xs + 3.0f, ys);
                        p.closePath();
                        g2.draw(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.maxCharHeight = this.plotStartY - 15;
        this.maxStringLength = 3 * this.plotSize.width / 4;
        this.minFontSize = 12;
        g2.setColor(this.labelColor);
        if (this.validTitle) {
            font = new Font("Helvetica", 1, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.title, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.title);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.title, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, this.plotStartY / 2 + this.stringHeight / 2);
        }
        if (this.validXLabel) {
            this.maxStringLength = this.plotSize.width;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.xLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.xLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xLabel, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, 3 * this.plotStartY / 2 + this.plotSize.height + this.stringHeight / 2);
        }
        if (this.validYLabel) {
            this.maxStringLength = this.plotSize.height;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.yLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.yLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            g2.setTransform(at);
            int xPos = this.plotStartY / 2 + this.plotSize.height / 2 + this.stringWidth / 2;
            int yPos = (int)(1.05 * (double)this.stringHeight);
            g2.drawString(this.yLabel, -xPos, yPos);
        }
        at = new AffineTransform();
        g2.setTransform(at);
        i = 0;
        while (i < this.totalAnnotations) {
            x1 = Math1.log10((double)this.xAnnPos[i]) - this.xMinLog;
            y1 = Math1.log10((double)this.yAnnPos[i]) - this.yMaxLog;
            this.maxCharHeight = 26;
            this.maxStringLength = this.logXAxis ? (int)Math.floor((this.xMaxLog - Math1.log10((double)this.xAnnPos[i])) * (double)this.plotSize.width) : (int)Math.floor((this.xMax - this.xAnnPos[i]) * (double)this.plotSize.width);
            this.minFontSize = 8;
            g2.setColor(this.annotationColor[i]);
            font = new Font("Helvetica", 0, 12);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.annotations[i], this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.annotations[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.annotations[i], (int)(x1 * this.xScale + (double)this.plotStartX), (int)(-y1 * this.yScale + (double)this.plotStartY));
            ++i;
        }
    }

    private void semilogx(Graphics2D g2) {
        AffineTransform at;
        double y1;
        double x1;
        int i;
        this.size = this.getSize();
        this.plotSize.width = Math.round((float)this.size.width * (1.0f - this.xLeftMargin - this.xRightMargin));
        this.plotSize.height = Math.round((float)this.size.height * (1.0f - this.yTopMargin - this.yBottomMargin));
        this.plotStartX = Math.round((float)this.size.width * this.xLeftMargin);
        this.plotStartY = Math.round((float)this.size.height * this.yTopMargin);
        if (this.autoXScale) {
            this.xMax = Array.maxVal((double[])this.xVal[0]);
            this.xMin = Array.minVal((double[])this.xVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.xMax = Math.max(this.xMax, Array.maxVal((double[])this.xVal[i]));
                this.xMin = Math.min(this.xMin, Array.minVal((double[])this.xVal[i]));
                ++i;
            }
            if (this.xMin <= 0.0) {
                String s = "Min x plot value <= 0 in logarithmic plot: " + this.xMin;
                throw new InvalidPlotValueException(s);
            }
            this.xMax = Math.pow(10.0, Math.ceil(Math1.log10((double)this.xMax)));
            this.xMin = Math.pow(10.0, Math.floor(Math1.log10((double)this.xMin)));
            if (this.xMin == this.xMax) {
                this.xMax = 1.01 * this.xMin;
            }
            this.xMaxLog = Math1.log10((double)this.xMax);
            this.xMinLog = Math1.log10((double)this.xMin);
        } else {
            if (this.xMin <= 0.0) {
                String s = "Min x plot value <= 0 in logarithmic plot: " + this.xMin;
                throw new InvalidPlotValueException(s);
            }
            if (this.xMin == this.xMax) {
                this.xMax = 1.01 * this.xMin;
            }
            this.xMaxLog = Math1.log10((double)this.xMax);
            this.xMinLog = Math1.log10((double)this.xMin);
        }
        if (this.autoYScale) {
            this.yMax = Array.maxVal((double[])this.yVal[0]);
            this.yMin = Array.minVal((double[])this.yVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.yMax = Math.max(this.yMax, Array.maxVal((double[])this.yVal[i]));
                this.yMin = Math.min(this.yMin, Array.minVal((double[])this.yVal[i]));
                ++i;
            }
        }
        if (this.autoXTicMode) {
            this.calcXLogTics(this.xMin, this.xMax);
        }
        if (this.autoYTicMode) {
            this.calcYTics(this.yMin, this.yMax);
        }
        this.xScale = Math.abs(this.xMaxLog - this.xMinLog) > 0.0 ? (double)this.plotSize.width / (this.xMaxLog - this.xMinLog) : 1.0;
        this.yScale = Math.abs(this.yMax - this.yMin) > 0.0 ? (double)this.plotSize.height / (this.yMax - this.yMin) : 1.0;
        g2.setStroke(this.bb);
        g2.setColor(this.boxColor);
        Line2D.Double line = new Line2D.Double(this.plotStartX, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY);
        g2.draw(line);
        g2.setStroke(this.bg);
        g2.setColor(this.gridColor);
        if (this.xGridLines) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yGridLines) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, this.plotStartX + this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        g2.setStroke(this.bt);
        g2.setColor(this.ticColor);
        if (this.xTicMarks) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.025 * (double)this.plotSize.height);
                g2.draw(line);
                line = new Line2D.Double((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height, (this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.975 * (double)this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yTicMarks) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.025 * (double)this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                line = new Line2D.Double(this.plotStartX + this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.975 * (double)this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = this.logXAxis ? (int)(this.xRightMargin * (float)this.plotSize.width) : (int)((double)this.plotSize.width / (1.2 * (double)this.xTic.length));
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        Font font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.xTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.xTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xTicS[i], (int)((this.xTicLog[i] - this.xMinLog) * this.xScale + (double)this.plotStartX - (double)(this.stringWidth / 2)), this.plotStartY + this.plotSize.height + 11);
            ++i;
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)(0.5 * (double)this.plotStartX);
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.yTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.yTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            int fudge = i == 0 ? 5 : 12;
            g2.drawString(this.yTicS[i], this.plotStartX - this.stringWidth - 6, (int)(-(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY - (double)(this.stringHeight / 2) + (double)fudge));
            ++i;
        }
        i = 0;
        while (i < this.totalCurves) {
            int j;
            if (this.plotLine[i]) {
                g2.setStroke(this.bs[i]);
                g2.setColor(this.lineColor[i]);
                j = 0;
                while (j < this.xVal[i].length - 1) {
                    x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                    double x2 = Math1.log10((double)this.xVal[i][j + 1]) - this.xMinLog;
                    y1 = this.yVal[i][j] - this.yMax;
                    double y2 = this.yVal[i][j + 1] - this.yMax;
                    line = new Line2D.Double(x1 * this.xScale + (double)this.plotStartX, -y1 * this.yScale + (double)this.plotStartY, x2 * this.xScale + (double)this.plotStartX, -y2 * this.yScale + (double)this.plotStartY);
                    g2.draw(line);
                    ++j;
                }
            }
            if (this.plotMarker[i]) {
                if (this.bm == null) {
                    this.bm = new BasicStroke(2.0f, 2, 0, 6.0f, LINESTYLE_SOLID, 0.0f);
                }
                g2.setStroke(this.bm);
                g2.setColor(this.markerColor[i]);
                j = 0;
                while (j < this.xVal[i].length) {
                    float ys;
                    float xs;
                    GeneralPath p;
                    if (this.markerStyle[i] == 1) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = this.yVal[i][j] - this.yMax;
                        Rectangle2D.Double rect = new Rectangle2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(rect);
                    }
                    if (this.markerStyle[i] == 2) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = this.yVal[i][j] - this.yMax;
                        Ellipse2D.Double ell = new Ellipse2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(ell);
                    }
                    if (this.markerStyle[i] == 3) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = this.yVal[i][j] - this.yMax;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 2.0);
                        p.moveTo(xs, ys);
                        p.lineTo(xs + 6.0f, ys);
                        p.lineTo(xs + 3.0f, ys - 5.2f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 4) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = this.yVal[i][j] - this.yMax;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY);
                        p.moveTo(xs - 4.0f, ys);
                        p.lineTo(xs, ys + 4.0f);
                        p.lineTo(xs + 4.0f, ys);
                        p.lineTo(xs, ys - 4.0f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 5) {
                        x1 = Math1.log10((double)this.xVal[i][j]) - this.xMinLog;
                        y1 = this.yVal[i][j] - this.yMax;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 3.0);
                        p.moveTo(xs, ys - 5.2f);
                        p.lineTo(xs + 6.0f, ys - 5.2f);
                        p.lineTo(xs + 3.0f, ys);
                        p.closePath();
                        g2.draw(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.maxCharHeight = this.plotStartY - 15;
        this.maxStringLength = 3 * this.plotSize.width / 4;
        this.minFontSize = 12;
        g2.setColor(this.labelColor);
        if (this.validTitle) {
            font = new Font("Helvetica", 1, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.title, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.title);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.title, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, this.plotStartY / 2 + this.stringHeight / 2);
        }
        if (this.validXLabel) {
            this.maxStringLength = this.plotSize.width;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.xLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.xLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xLabel, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, 3 * this.plotStartY / 2 + this.plotSize.height + this.stringHeight / 2);
        }
        if (this.validYLabel) {
            this.maxStringLength = this.plotSize.height;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.yLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.yLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            g2.setTransform(at);
            int xPos = this.plotStartY / 2 + this.plotSize.height / 2 + this.stringWidth / 2;
            int yPos = (int)(1.05 * (double)this.stringHeight);
            g2.drawString(this.yLabel, -xPos, yPos);
        }
        at = new AffineTransform();
        g2.setTransform(at);
        i = 0;
        while (i < this.totalAnnotations) {
            x1 = Math1.log10((double)this.xAnnPos[i]) - this.xMinLog;
            y1 = this.yAnnPos[i] - this.yMax;
            this.maxCharHeight = 26;
            this.maxStringLength = this.logXAxis ? (int)Math.floor((this.xMaxLog - Math1.log10((double)this.xAnnPos[i])) * (double)this.plotSize.width) : (int)Math.floor((this.xMax - this.xAnnPos[i]) * (double)this.plotSize.width);
            this.minFontSize = 8;
            g2.setColor(this.annotationColor[i]);
            font = new Font("Helvetica", 0, 12);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.annotations[i], this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.annotations[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.annotations[i], (int)(x1 * this.xScale + (double)this.plotStartX), (int)(-y1 * this.yScale + (double)this.plotStartY));
            ++i;
        }
    }

    private void semilogy(Graphics2D g2) {
        AffineTransform at;
        double y1;
        double x1;
        int i;
        this.size = this.getSize();
        this.plotSize.width = Math.round((float)this.size.width * (1.0f - this.xLeftMargin - this.xRightMargin));
        this.plotSize.height = Math.round((float)this.size.height * (1.0f - this.yTopMargin - this.yBottomMargin));
        this.plotStartX = Math.round((float)this.size.width * this.xLeftMargin);
        this.plotStartY = Math.round((float)this.size.height * this.yTopMargin);
        if (this.autoXScale) {
            this.xMax = Array.maxVal((double[])this.xVal[0]);
            this.xMin = Array.minVal((double[])this.xVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.xMax = Math.max(this.xMax, Array.maxVal((double[])this.xVal[i]));
                this.xMin = Math.min(this.xMin, Array.minVal((double[])this.xVal[i]));
                ++i;
            }
        }
        if (this.autoYScale) {
            this.yMax = Array.maxVal((double[])this.yVal[0]);
            this.yMin = Array.minVal((double[])this.yVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.yMax = Math.max(this.yMax, Array.maxVal((double[])this.yVal[i]));
                this.yMin = Math.min(this.yMin, Array.minVal((double[])this.yVal[i]));
                ++i;
            }
            if (this.yMin <= 0.0) {
                String s = "Min y plot value <= 0 in logarithmic plot: " + this.yMin;
                throw new InvalidPlotValueException(s);
            }
            this.yMax = Math.pow(10.0, Math.ceil(Math1.log10((double)this.yMax)));
            this.yMin = Math.pow(10.0, Math.floor(Math1.log10((double)this.yMin)));
            if (this.yMin == this.yMax) {
                this.yMax = 1.01 * this.yMin;
            }
            this.yMaxLog = Math1.log10((double)this.yMax);
            this.yMinLog = Math1.log10((double)this.yMin);
        } else {
            if (this.yMin <= 0.0) {
                String s = "Min y plot value <= 0 in logarithmic plot: " + this.yMin;
                throw new InvalidPlotValueException(s);
            }
            if (this.yMin == this.yMax) {
                this.yMax = 1.01 * this.yMin;
            }
            this.yMaxLog = Math1.log10((double)this.yMax);
            this.yMinLog = Math1.log10((double)this.yMin);
        }
        if (this.autoXTicMode) {
            this.calcXTics(this.xMin, this.xMax);
        }
        if (this.autoYTicMode) {
            this.calcYLogTics(this.yMin, this.yMax);
        }
        this.xScale = Math.abs(this.xMax - this.xMin) > 0.0 ? (double)this.plotSize.width / (this.xMax - this.xMin) : 1.0;
        this.yScale = Math.abs(this.yMaxLog - this.yMinLog) > 0.0 ? (double)this.plotSize.height / (this.yMaxLog - this.yMinLog) : 1.0;
        g2.setStroke(this.bb);
        g2.setColor(this.boxColor);
        Line2D.Double line = new Line2D.Double(this.plotStartX, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY);
        g2.draw(line);
        g2.setStroke(this.bg);
        g2.setColor(this.gridColor);
        if (this.xGridLines) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yGridLines) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY, this.plotStartX + this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        if (this.bt == null) {
            float[] ticStyle = new float[]{12.0f, 0.0f};
            this.bt = new BasicStroke(1.0f, 2, 0, 6.0f, ticStyle, 0.0f);
        }
        g2.setStroke(this.bt);
        g2.setColor(this.ticColor);
        if (this.xTicMarks) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.025 * (double)this.plotSize.height);
                g2.draw(line);
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, (double)this.plotStartY + 0.975 * (double)this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yTicMarks) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.025 * (double)this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                line = new Line2D.Double(this.plotStartX + this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.975 * (double)this.plotSize.width, -(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = this.logXAxis ? (int)(this.xRightMargin * (float)this.plotSize.width) : (int)((double)this.plotSize.width / (1.2 * (double)this.xTic.length));
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        Font font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.xTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.xTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xTicS[i], (int)((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX - (double)(this.stringWidth / 2)), this.plotStartY + this.plotSize.height + 11);
            ++i;
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)(0.5 * (double)this.plotStartX);
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.yTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.yTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            int fudge = i == 0 ? 5 : 12;
            g2.drawString(this.yTicS[i], this.plotStartX - this.stringWidth - 6, (int)(-(this.yTicLog[i] - this.yMaxLog) * this.yScale + (double)this.plotStartY - (double)(this.stringHeight / 2) + (double)fudge));
            ++i;
        }
        i = 0;
        while (i < this.totalCurves) {
            int j;
            if (this.plotLine[i]) {
                g2.setStroke(this.bs[i]);
                g2.setColor(this.lineColor[i]);
                j = 0;
                while (j < this.xVal[i].length - 1) {
                    x1 = this.xVal[i][j] - this.xMin;
                    double x2 = this.xVal[i][j + 1] - this.xMin;
                    y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                    double y2 = Math1.log10((double)this.yVal[i][j + 1]) - this.yMaxLog;
                    line = new Line2D.Double(x1 * this.xScale + (double)this.plotStartX, -y1 * this.yScale + (double)this.plotStartY, x2 * this.xScale + (double)this.plotStartX, -y2 * this.yScale + (double)this.plotStartY);
                    g2.draw(line);
                    ++j;
                }
            }
            if (this.plotMarker[i]) {
                if (this.bm == null) {
                    this.bm = new BasicStroke(2.0f, 2, 0, 6.0f, LINESTYLE_SOLID, 0.0f);
                }
                g2.setStroke(this.bm);
                g2.setColor(this.markerColor[i]);
                j = 0;
                while (j < this.xVal[i].length) {
                    float ys;
                    float xs;
                    GeneralPath p;
                    if (this.markerStyle[i] == 1) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        Rectangle2D.Double rect = new Rectangle2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(rect);
                    }
                    if (this.markerStyle[i] == 2) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        Ellipse2D.Double ell = new Ellipse2D.Double(x1 * this.xScale + (double)this.plotStartX - 3.0, -y1 * this.yScale + (double)this.plotStartY - 3.0, 6.0, 6.0);
                        g2.draw(ell);
                    }
                    if (this.markerStyle[i] == 3) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 2.0);
                        p.moveTo(xs, ys);
                        p.lineTo(xs + 6.0f, ys);
                        p.lineTo(xs + 3.0f, ys - 5.2f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 4) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY);
                        p.moveTo(xs - 4.0f, ys);
                        p.lineTo(xs, ys + 4.0f);
                        p.lineTo(xs + 4.0f, ys);
                        p.lineTo(xs, ys - 4.0f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 5) {
                        x1 = this.xVal[i][j] - this.xMin;
                        y1 = Math1.log10((double)this.yVal[i][j]) - this.yMaxLog;
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 3.0);
                        p.moveTo(xs, ys - 5.2f);
                        p.lineTo(xs + 6.0f, ys - 5.2f);
                        p.lineTo(xs + 3.0f, ys);
                        p.closePath();
                        g2.draw(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.maxCharHeight = this.plotStartY - 15;
        this.maxStringLength = 3 * this.plotSize.width / 4;
        this.minFontSize = 12;
        g2.setColor(this.labelColor);
        if (this.validTitle) {
            font = new Font("Helvetica", 1, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.title, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.title);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.title, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, this.plotStartY / 2 + this.stringHeight / 2);
        }
        if (this.validXLabel) {
            this.maxStringLength = this.plotSize.width;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.xLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.xLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xLabel, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, 3 * this.plotStartY / 2 + this.plotSize.height + this.stringHeight / 2);
        }
        if (this.validYLabel) {
            this.maxStringLength = this.plotSize.height;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.yLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.yLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            g2.setTransform(at);
            int xPos = this.plotStartY / 2 + this.plotSize.height / 2 + this.stringWidth / 2;
            int yPos = (int)(1.05 * (double)this.stringHeight);
            g2.drawString(this.yLabel, -xPos, yPos);
        }
        at = new AffineTransform();
        g2.setTransform(at);
        i = 0;
        while (i < this.totalAnnotations) {
            x1 = this.xAnnPos[i] - this.xMin;
            y1 = Math1.log10((double)this.yAnnPos[i]) - this.yMaxLog;
            this.maxCharHeight = 26;
            this.maxStringLength = this.logXAxis ? (int)Math.floor((this.xMaxLog - Math1.log10((double)this.xAnnPos[i])) * (double)this.plotSize.width) : (int)Math.floor((this.xMax - this.xAnnPos[i]) * (double)this.plotSize.width);
            this.minFontSize = 8;
            g2.setColor(this.annotationColor[i]);
            font = new Font("Helvetica", 0, 12);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.annotations[i], this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.annotations[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.annotations[i], (int)(x1 * this.xScale + (double)this.plotStartX), (int)(-y1 * this.yScale + (double)this.plotStartY));
            ++i;
        }
    }

    private void polar(Graphics2D g2) {
        int fudge;
        Line2D.Double line;
        double temp2;
        double temp1;
        int j;
        int i;
        this.size = this.getSize();
        this.plotSize.width = Math.round((float)this.size.width * (1.0f - this.xLeftMargin - this.xRightMargin));
        this.plotSize.height = Math.round((float)this.size.height * (1.0f - this.yTopMargin - this.yBottomMargin));
        this.plotStartX = Math.round((float)this.size.width * this.xLeftMargin);
        this.plotStartY = Math.round((float)this.size.height * this.yTopMargin);
        if (this.autoXScale || this.autoYScale) {
            this.xMax = Math.abs(this.xVal[0][0]);
            i = 0;
            while (i < this.totalCurves) {
                j = 0;
                while (j < this.xVal[i].length) {
                    this.xMax = Math.max(this.xMax, Math.abs(this.xVal[i][j]));
                    ++j;
                }
                ++i;
            }
        }
        this.xMin = -this.xMax;
        this.yMax = this.xMax;
        this.yMin = -this.xMax;
        this.calcPolarCircles(this.yMax);
        this.xScale = Math.abs(this.xMax - this.xMin) > 0.0 ? (double)Math.min(this.plotSize.width, this.plotSize.height) / (this.xMax - this.xMin) : 1.0;
        this.yScale = Math.abs(this.yMax - this.yMin) > 0.0 ? (double)Math.min(this.plotSize.width, this.plotSize.height) / (this.yMax - this.yMin) / 2.0 : 1.0;
        g2.setStroke(this.bb);
        g2.setColor(this.boxColor);
        double x1 = -this.xMin;
        double y1 = -this.yMax;
        Ellipse2D.Double ell = new Ellipse2D.Double((double)(this.plotStartX + this.plotSize.width / 2) - x1 * this.xScale, (double)(this.plotStartY + this.plotSize.height / 2) + y1 * this.yScale, 2.0 * this.xMax * this.xScale, 2.0 * this.yMax * this.yScale);
        g2.draw(ell);
        g2.setStroke(this.bg);
        g2.setColor(this.gridColor);
        if (this.xGridLines) {
            i = 0;
            while (i < 8) {
                temp1 = this.xMax * Math.cos((double)i * Math.PI / 4.0);
                temp2 = this.xMax * Math.sin((double)i * Math.PI / 4.0);
                line = new Line2D.Double(this.plotStartX + this.plotSize.width / 2, this.plotStartY + this.plotSize.height / 2, (double)(this.plotStartX + this.plotSize.width / 2) + temp1 * this.xScale, (double)(this.plotStartY + this.plotSize.height / 2) + temp2 * this.yScale);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yGridLines) {
            i = 1;
            while (i < this.yTic.length - 1) {
                ell = new Ellipse2D.Double((double)(this.plotStartX + this.plotSize.width / 2) - this.yTic[i] * this.xScale, (double)(this.plotStartY + this.plotSize.height / 2) - this.yTic[i] * this.yScale, 2.0 * this.yTic[i] * this.xScale, 2.0 * this.yTic[i] * this.yScale);
                g2.draw(ell);
                ++i;
            }
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)(0.5 * (double)this.plotStartX);
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        Font font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.yTicS[0], this.maxStringLength);
        i = 0;
        while (i < 8) {
            fudge = 4;
            String s = "" + i * 30 + '\u00b0';
            this.stringWidth = this.fontMetrics.stringWidth(s);
            this.stringHeight = this.fontMetrics.getHeight();
            temp1 = (this.xMax + (double)(4 + this.stringWidth / 2) / this.xScale) * Math.cos((double)i * Math.PI / 4.0);
            temp2 = (this.xMax + (double)(4 + this.stringHeight / 2) / this.yScale) * Math.sin((double)i * Math.PI / 4.0);
            if (i != 2) {
                g2.drawString(s, (int)((double)(this.plotStartX + this.plotSize.width / 2) + temp1 * this.xScale - (double)(this.stringWidth / 2)), (int)((double)(this.plotStartY + this.plotSize.height / 2) - temp2 * this.yScale - (double)fudge + (double)(this.stringHeight / 2)));
            }
            ++i;
        }
        i = 1;
        while (i < this.yTicS.length) {
            fudge = 4;
            this.stringWidth = this.fontMetrics.stringWidth(this.yTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            temp1 = this.yTic[i] * Math.cos(1.1780972450961724);
            temp2 = this.yTic[i] * Math.sin(1.1780972450961724);
            g2.drawString(this.yTicS[i], (int)((double)(this.plotStartX + this.plotSize.width / 2) + temp1 * this.xScale - 6.0), (int)((double)(this.plotStartY + this.plotSize.height / 2) - temp2 * this.yScale - (double)fudge));
            ++i;
        }
        i = 0;
        while (i < this.totalCurves) {
            if (this.plotLine[i]) {
                g2.setStroke(this.bs[i]);
                g2.setColor(this.lineColor[i]);
                j = 0;
                while (j < this.xVal[i].length - 1) {
                    x1 = this.xVal[i][j] * Math.cos(-this.yVal[i][j]);
                    y1 = this.xVal[i][j] * Math.sin(-this.yVal[i][j]);
                    double x2 = this.xVal[i][j + 1] * Math.cos(-this.yVal[i][j + 1]);
                    double y2 = this.xVal[i][j + 1] * Math.sin(-this.yVal[i][j + 1]);
                    line = new Line2D.Double((double)(this.plotStartX + this.plotSize.width / 2) + x1 * this.xScale, (double)(this.plotStartY + this.plotSize.height / 2) + y1 * this.yScale, (double)(this.plotStartX + this.plotSize.width / 2) + x2 * this.xScale, (double)(this.plotStartY + this.plotSize.height / 2) + y2 * this.yScale);
                    g2.draw(line);
                    ++j;
                }
            }
            if (this.plotMarker[i]) {
                if (this.bm == null) {
                    this.bm = new BasicStroke(2.0f, 2, 0, 6.0f, LINESTYLE_SOLID, 0.0f);
                }
                g2.setStroke(this.bm);
                g2.setColor(this.markerColor[i]);
                j = 0;
                while (j < this.xVal[i].length) {
                    float ys;
                    float xs;
                    GeneralPath p;
                    if (this.markerStyle[i] == 1) {
                        x1 = this.xVal[i][j] * Math.cos(-this.yVal[i][j]);
                        y1 = this.xVal[i][j] * Math.sin(-this.yVal[i][j]);
                        Rectangle2D.Double rect = new Rectangle2D.Double((double)(this.plotStartX + this.plotSize.width / 2) + x1 * this.xScale - 3.0, (double)(this.plotStartY + this.plotSize.height / 2) + y1 * this.yScale - 3.0, 6.0, 6.0);
                        g2.draw(rect);
                    }
                    if (this.markerStyle[i] == 2) {
                        x1 = this.xVal[i][j] * Math.cos(-this.yVal[i][j]);
                        y1 = this.xVal[i][j] * Math.sin(-this.yVal[i][j]);
                        ell = new Ellipse2D.Double((double)(this.plotStartX + this.plotSize.width / 2) + x1 * this.xScale - 3.0, (double)(this.plotStartY + this.plotSize.height / 2) + y1 * this.yScale - 3.0, 6.0, 6.0);
                        g2.draw(ell);
                    }
                    if (this.markerStyle[i] == 3) {
                        x1 = this.xVal[i][j] * Math.cos(-this.yVal[i][j]);
                        y1 = this.xVal[i][j] * Math.sin(-this.yVal[i][j]);
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 2.0);
                        p.moveTo(xs, ys);
                        p.lineTo(xs + 6.0f, ys);
                        p.lineTo(xs + 3.0f, ys - 5.2f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 4) {
                        x1 = this.xVal[i][j] * Math.cos(-this.yVal[i][j]);
                        y1 = this.xVal[i][j] * Math.sin(-this.yVal[i][j]);
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY);
                        p.moveTo(xs - 4.0f, ys);
                        p.lineTo(xs, ys + 4.0f);
                        p.lineTo(xs + 4.0f, ys);
                        p.lineTo(xs, ys - 4.0f);
                        p.closePath();
                        g2.draw(p);
                    }
                    if (this.markerStyle[i] == 5) {
                        x1 = this.xVal[i][j] * Math.cos(-this.yVal[i][j]);
                        y1 = this.xVal[i][j] * Math.sin(-this.yVal[i][j]);
                        p = new GeneralPath();
                        xs = (float)(x1 * this.xScale + (double)this.plotStartX - 3.0);
                        ys = (float)(-y1 * this.yScale + (double)this.plotStartY + 3.0);
                        p.moveTo(xs, ys - 5.2f);
                        p.lineTo(xs + 6.0f, ys - 5.2f);
                        p.lineTo(xs + 3.0f, ys);
                        p.closePath();
                        g2.draw(p);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.maxCharHeight = this.plotStartY - 15;
        this.maxStringLength = 3 * this.plotSize.width / 4;
        this.minFontSize = 12;
        g2.setColor(this.labelColor);
        if (this.validTitle) {
            font = new Font("Helvetica", 1, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.title, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.title);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.title, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, this.plotStartY / 2 + this.stringHeight / 2);
        }
        if (this.validXLabel) {
            this.maxStringLength = this.plotSize.width;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.xLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.xLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xLabel, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, 3 * this.plotStartY / 2 + this.plotSize.height + this.stringHeight / 2);
        }
        if (this.validYLabel) {
            this.maxStringLength = this.plotSize.height;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.yLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.yLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            AffineTransform at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            g2.setTransform(at);
            int xPos = this.plotStartY / 2 + this.plotSize.height / 2 + this.stringWidth / 2;
            int yPos = (int)(1.05 * (double)this.stringHeight);
            g2.drawString(this.yLabel, -xPos, yPos);
        }
    }

    private void bar(Graphics2D g2) {
        double y1;
        double x1;
        double spacing;
        int i;
        double dx = 1.0;
        this.size = this.getSize();
        this.plotSize.width = Math.round((float)this.size.width * (1.0f - this.xLeftMargin - this.xRightMargin));
        this.plotSize.height = Math.round((float)this.size.height * (1.0f - this.yTopMargin - this.yBottomMargin));
        this.plotStartX = Math.round((float)this.size.width * this.xLeftMargin);
        this.plotStartY = Math.round((float)this.size.height * this.yTopMargin);
        this.barStartX = (int)((double)this.plotStartX + 0.05 * (double)this.plotSize.width);
        if (this.autoXScale) {
            double dx2;
            double dx1;
            if (this.xVal[0].length > 1) {
                dx1 = this.xVal[0][1] - this.xVal[0][0];
                dx2 = this.xVal[0][this.xVal[0].length - 1] - this.xVal[0][this.xVal[0].length - 2];
            } else {
                dx1 = 0.5;
                dx2 = 0.5;
            }
            this.xMin = Array.minVal((double[])this.xVal[0]) - dx1 / 2.0;
            this.xMax = Array.maxVal((double[])this.xVal[0]) + dx2 / 2.0;
            i = 1;
            while (i < this.totalCurves) {
                if (this.xVal[i].length > 1) {
                    dx1 = this.xVal[i][1] - this.xVal[i][0];
                    dx2 = this.xVal[i][this.xVal[i].length - 1] - this.xVal[i][this.xVal[i].length - 2];
                } else {
                    dx1 = 0.5;
                    dx2 = 0.5;
                }
                this.xMin = Math.min(this.xMin, Array.minVal((double[])this.xVal[i]) - dx1 / 2.0);
                this.xMax = Math.max(this.xMax, Array.maxVal((double[])this.xVal[i]) + dx2 / 2.0);
                ++i;
            }
        }
        if (this.autoYScale) {
            this.yMax = Array.maxVal((double[])this.yVal[0]);
            this.yMin = Array.minVal((double[])this.yVal[0]);
            i = 1;
            while (i < this.totalCurves) {
                this.yMax = Math.max(this.yMax, Array.maxVal((double[])this.yVal[i]));
                this.yMin = Math.min(this.yMin, Array.minVal((double[])this.yVal[i]));
                ++i;
            }
        }
        if (this.yMin < 0.0) {
            String s = "Min y value < 0 in Bar plot: " + this.yMin;
            throw new InvalidPlotValueException(s);
        }
        this.yMin = 0.0;
        if (this.autoXTicMode) {
            this.calcXTics(this.xMin, this.xMax);
        }
        if (this.autoYTicMode) {
            this.calcYTics(this.yMin, this.yMax);
        }
        if (Math.abs(this.xTic[this.xTic.length - 1] - this.xTic[0]) > 0.0) {
            spacing = this.xVal[0].length > 1 ? (this.xTic[this.xTic.length - 1] - this.xTic[0]) / (double)(this.xVal[0].length - 1) : 1.0;
            this.xScale = (double)this.plotSize.width / (this.xTic[this.xTic.length - 1] - this.xTic[0] + spacing);
        } else {
            this.xScale = 1.0;
            spacing = 1.0;
        }
        this.yScale = Math.abs(this.yTic[this.yTic.length - 1] - this.yTic[0]) > 0.0 ? (double)this.plotSize.height / (this.yTic[this.yTic.length - 1] - this.yTic[0]) : 1.0;
        g2.setStroke(this.bb);
        g2.setColor(this.boxColor);
        Line2D.Double line = new Line2D.Double(this.plotStartX, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY, this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX + this.plotSize.width, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY + this.plotSize.height);
        g2.draw(line);
        line = new Line2D.Double(this.plotStartX, this.plotStartY + this.plotSize.height, this.plotStartX, this.plotStartY);
        g2.draw(line);
        g2.setStroke(this.bg);
        g2.setColor(this.gridColor);
        if (this.xGridLines) {
            i = 1;
            while (i < this.xTic.length - 1) {
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY, (this.xTic[i] - this.xMin) * this.xScale + (double)this.plotStartX, this.plotStartY + this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yGridLines) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, this.plotStartX + this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        g2.setStroke(this.bt);
        g2.setColor(this.ticColor);
        if (this.xTicMarks) {
            i = 0;
            while (i < this.xTic.length) {
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.barStartX, this.plotStartY, (this.xTic[i] - this.xMin) * this.xScale + (double)this.barStartX, (double)this.plotStartY + 0.025 * (double)this.plotSize.height);
                g2.draw(line);
                line = new Line2D.Double((this.xTic[i] - this.xMin) * this.xScale + (double)this.barStartX, this.plotStartY + this.plotSize.height, (this.xTic[i] - this.xMin) * this.xScale + (double)this.barStartX, (double)this.plotStartY + 0.975 * (double)this.plotSize.height);
                g2.draw(line);
                ++i;
            }
        }
        if (this.yTicMarks) {
            i = 1;
            while (i < this.yTic.length - 1) {
                line = new Line2D.Double(this.plotStartX, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.025 * (double)this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                line = new Line2D.Double(this.plotStartX + this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY, (double)this.plotStartX + 0.975 * (double)this.plotSize.width, -(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY);
                g2.draw(line);
                ++i;
            }
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)((double)this.plotSize.width / (1.2 * (double)this.xTic.length));
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        Font font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.xTicS.length) {
            this.stringWidth = this.fontMetrics.stringWidth(this.xTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xTicS[i], (int)((this.xTic[i] - this.xMin) * this.xScale + (double)this.barStartX - (double)(this.stringWidth / 2)), this.plotStartY + this.plotSize.height + 11);
            ++i;
        }
        this.maxCharHeight = (this.size.height - this.plotSize.height - this.plotStartY) / 2;
        this.maxStringLength = (int)(0.5 * (double)this.plotStartX);
        this.minFontSize = 8;
        g2.setColor(this.labelColor);
        font = new Font("Helvetica", 0, 12);
        g2.setFont(font);
        this.fontMetrics = this.pickFont(g2, this.xTicS[0], this.maxStringLength);
        i = 0;
        while (i < this.yTicS.length) {
            int fudge = i == 0 ? 5 : 12;
            this.stringWidth = this.fontMetrics.stringWidth(this.yTicS[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.yTicS[i], this.plotStartX - this.stringWidth - 6, (int)(-(this.yTic[i] - this.yMax) * this.yScale + (double)this.plotStartY - (double)(this.stringHeight / 2) + (double)fudge));
            ++i;
        }
        i = 0;
        while (i < this.totalCurves) {
            g2.setStroke(this.bs[i]);
            g2.setColor(this.lineColor[i]);
            int j = 0;
            while (j < this.xVal[i].length) {
                double w1;
                if (j == 0 && this.xVal[i].length == 1) {
                    dx = this.xMax - this.xMin;
                    x1 = this.xVal[i][j] - dx / 2.0 - this.xMin;
                    w1 = dx;
                } else if (j == 0) {
                    dx = this.xVal[i][j + 1] - this.xVal[i][j];
                    x1 = this.xVal[i][j] - dx / 2.0 - this.xMin;
                    w1 = dx;
                } else if (j == this.xVal[i].length - 1) {
                    dx = this.xVal[i][j] - this.xVal[i][j - 1];
                    x1 = this.xVal[i][j] - dx / 2.0 - this.xMin;
                    w1 = dx;
                } else {
                    dx = (this.xVal[i][j + 1] - this.xVal[i][j - 1]) / 2.0;
                    x1 = (this.xVal[i][j] + this.xVal[i][j - 1]) / 2.0 - this.xMin;
                    w1 = dx;
                }
                if (this.totalCurves > 1) {
                    double ds = dx / (double)(this.totalCurves + 1);
                    x1 = this.xVal[i][j] - this.xMin + (double)(i - 1) * ds - ds / 2.0;
                    w1 = ds;
                }
                y1 = this.yVal[i][j] - this.yMax;
                double h1 = this.yMax + y1;
                Rectangle2D.Double rect = new Rectangle2D.Double(x1 * this.xScale + (double)this.barStartX, -y1 * this.yScale + (double)this.plotStartY, w1 * this.xScale, h1 * this.yScale - 1.0);
                g2.setColor(this.fillColor[i]);
                g2.fill(rect);
                g2.setColor(Color.black);
                g2.draw(rect);
                ++j;
            }
            ++i;
        }
        this.maxCharHeight = this.plotStartY - 15;
        this.maxStringLength = 3 * this.plotSize.width / 4;
        this.minFontSize = 12;
        g2.setColor(this.labelColor);
        if (this.validTitle) {
            font = new Font("Helvetica", 1, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.title, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.title);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.title, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, this.plotStartY / 2 + this.stringHeight / 2);
        }
        if (this.validXLabel) {
            this.maxStringLength = this.plotSize.width;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.xLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.xLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.xLabel, this.plotStartX + this.plotSize.width / 2 - this.stringWidth / 2, 3 * this.plotStartY / 2 + this.plotSize.height + this.stringHeight / 2);
        }
        if (this.validYLabel) {
            this.maxStringLength = this.plotSize.height;
            font = new Font("Helvetica", 0, 18);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.yLabel, this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.yLabel);
            this.stringHeight = this.fontMetrics.getHeight();
            AffineTransform at = new AffineTransform();
            at.rotate(-1.5707963267948966);
            g2.setTransform(at);
            int xPos = this.plotStartY / 2 + this.plotSize.height / 2 + this.stringWidth / 2;
            int yPos = (int)(1.05 * (double)this.stringHeight);
            g2.drawString(this.yLabel, -xPos, yPos);
        }
        AffineTransform at = new AffineTransform();
        g2.setTransform(at);
        i = 0;
        while (i < this.totalAnnotations) {
            x1 = this.xAnnPos[i] - this.xMin;
            y1 = this.yAnnPos[i] - this.yMax;
            this.maxCharHeight = 26;
            this.maxStringLength = this.logXAxis ? (int)Math.floor((this.xMaxLog - Math1.log10((double)this.xAnnPos[i])) * (double)this.plotSize.width) : (int)Math.floor((this.xMax - this.xAnnPos[i]) * (double)this.plotSize.width);
            this.minFontSize = 8;
            g2.setColor(this.annotationColor[i]);
            font = new Font("Helvetica", 0, 12);
            g2.setFont(font);
            this.fontMetrics = this.pickFont(g2, this.annotations[i], this.maxStringLength);
            this.stringWidth = this.fontMetrics.stringWidth(this.annotations[i]);
            this.stringHeight = this.fontMetrics.getHeight();
            g2.drawString(this.annotations[i], (int)(x1 * this.xScale + (double)this.plotStartX), (int)(-y1 * this.yScale + (double)this.plotStartY));
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat portrait = e.getActionCommand().equals("Print") ? printJob.defaultPage() : printJob.pageDialog(printJob.defaultPage());
        portrait.setOrientation(1);
        Book bk = new Book();
        bk.append(this, portrait);
        printJob.setPageable(bk);
        try {
            printJob.print();
        }
        catch (Exception PrintException) {}
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(this, e.getX(), e.getY());
        }
        super.processMouseEvent(e);
    }
}

