/*
 * Decompiled with CFR 0.152.
 */
package chapman.graphics;

import chapman.graphics.JPlot2D;
import chapman.math.Array;
import java.io.Serializable;

public class JHist
extends JPlot2D
implements Cloneable,
Serializable {
    private double yMinVal;
    private double yMaxVal;
    private double[] bins;
    private double[] binCenter;
    private double binWidth;
    private int nBins;
    private double[] data;

    public JHist() {
        this.setPlotType(5);
        this.nBins = 10;
    }

    public JHist(int nBins) {
        this.setPlotType(5);
        this.nBins = nBins;
    }

    public JHist(double[] x) {
        this.data = x;
        this.setPlotType(5);
        this.nBins = 10;
        this.calcHist();
    }

    public JHist(double[] x, int nBins) {
        this.data = x;
        this.setPlotType(5);
        this.nBins = nBins;
        this.calcHist();
    }

    public JHist(double[] x, double[] binCenters) {
        this.data = x;
        this.binCenter = binCenters;
        this.setPlotType(5);
        this.nBins = binCenters.length;
        this.calcHist2();
    }

    private void calcHist() {
        this.bins = new double[this.nBins];
        this.yMaxVal = Array.maxVal((double[])this.data);
        this.yMinVal = Array.minVal((double[])this.data);
        this.binWidth = (this.yMaxVal - this.yMinVal) / (double)this.nBins;
        this.binCenter = new double[this.nBins];
        int i = 0;
        while (i < this.bins.length) {
            this.binCenter[i] = ((double)i + 0.5) * this.binWidth + this.yMinVal;
            ++i;
        }
        i = 0;
        while (i < this.data.length) {
            int index = (int)((this.data[i] - this.yMinVal) / this.binWidth);
            if (index == this.nBins) {
                // empty if block
            }
            int n = --index;
            this.bins[n] = this.bins[n] + 1.0;
            ++i;
        }
        this.setValues(this.binCenter, this.bins);
    }

    private void calcHist2() {
        this.bins = new double[this.nBins];
        this.yMaxVal = Array.maxVal((double[])this.data);
        this.yMinVal = Array.minVal((double[])this.data);
        double[] binBounds = new double[this.nBins - 1];
        int i = 0;
        while (i < binBounds.length) {
            binBounds[i] = (this.binCenter[i] + this.binCenter[i + 1]) / 2.0;
            ++i;
        }
        i = 0;
        while (i < this.data.length) {
            if (this.data[i] <= binBounds[0]) {
                this.bins[0] = this.bins[0] + 1.0;
            } else if (this.data[i] > binBounds[binBounds.length - 1]) {
                int n = this.bins.length - 1;
                this.bins[n] = this.bins[n] + 1.0;
            } else {
                int j = 0;
                while (j < binBounds.length) {
                    if (this.data[i] > binBounds[j] && this.data[i] <= binBounds[j + 1]) {
                        int n = j + 1;
                        this.bins[n] = this.bins[n] + 1.0;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.setValues(this.binCenter, this.bins);
    }

    public void setData(double[] x) {
        this.data = x;
        this.calcHist();
    }

    public void setNBins(int nBins) {
        this.nBins = nBins;
        this.calcHist();
    }

    public double[] getBinCenter() {
        return this.binCenter;
    }

    public double[] getBins() {
        return this.bins;
    }

    public double getMode() {
        int loc = Array.maxLoc((double[])this.bins);
        return this.binCenter[loc];
    }
}

